/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.inspector.msro.progress.ProgressProvider;
import eu.dnetlib.enabling.manager.msro.wf.SleepJobQuartz;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class SleepJob
extends AbstractJobNode {
    private int time = 5000;
    private static final int N_STEPS = 20;
    @Resource(name="sleepJobScheduler")
    private Scheduler jobScheduler;
    private static final Log log = LogFactory.getLog(SleepJob.class);

    public void execute(Engine engine, NodeToken token) {
        try {
            long start = System.currentTimeMillis();
            long step = this.time / 20;
            SleepProgress progress = new SleepProgress();
            this.setProgressProvider(progress);
            SimpleTrigger trigger = new SimpleTrigger("sleepTrigger-" + UUID.randomUUID());
            trigger.setStartTime(new Date(start));
            trigger.setRepeatInterval(step);
            trigger.setRepeatCount(20);
            JobDetail job = new JobDetail("job-" + UUID.randomUUID().toString(), SleepJobQuartz.class);
            job.getJobDataMap().put((Object)"sleepJob", (Object)this);
            job.getJobDataMap().put((Object)"engine", (Object)engine);
            job.getJobDataMap().put((Object)"token", (Object)token);
            job.getJobDataMap().put((Object)"progress", (Object)progress);
            this.jobScheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    public void finish(Engine engine, NodeToken token) {
        log.debug((Object)"FINISH NODE");
        super.execute(engine, token);
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public class SleepProgress
    implements ProgressProvider {
        private int current = 0;

        @Override
        public int getCurrentValue(Node node, NodeToken token) {
            log.debug((Object)("CURRENT " + this.current));
            return this.current;
        }

        public boolean updateCurrent() {
            if (this.current < 20) {
                ++this.current;
                return true;
            }
            return false;
        }

        @Override
        public int getTotalValue(Node node, NodeToken token) {
            log.debug((Object)"TOTAL 20");
            return 20;
        }

        @Override
        public boolean isInaccurate() {
            return false;
        }
    }
}

