/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;
import eu.dnetlib.workflow.AbstractJobNode;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class RepositoryReindexJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(RepositoryReindexJob.class);
    private String repositoryId;
    private String repositoryName;
    @Resource
    private SplittedQueryExecutor splittedQueryExecutor;
    private List<String> formatBlacklist = new ArrayList<String>();
    private String layout = "index";
    private String interpretation = "driver";
    private Graph subGraph;
    private GraphProcessRegistry processRegistry;

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)("executing " + (Object)((Object)this) + " repo: " + this.repositoryName));
        Iterable stores = this.splittedQueryExecutor.query(this.mdstoresQuery(this.repositoryId), new String[]{"id", "format"});
        for (Map store : stores) {
            if (this.formatBlacklist.contains(store.get("format"))) continue;
            this.reindexStore(engine, token, (String)store.get("id"), (String)store.get("format"), this.layout, this.interpretation);
        }
    }

    protected abstract String mdstoresQuery(String var1);

    private void reindexStore(Engine engine, NodeToken token, String mdId, String format, String layout, String interpretation) {
        log.info((Object)("REINDEXING STORE: " + format));
        GraphProcess subProcess = engine.getFactory().newNestedProcess(this.subGraph, token);
        Env env = subProcess.getEnv();
        env.setAttribute("mdId", mdId);
        env.setAttribute("format", format);
        env.setAttribute("interpretation", interpretation);
        env.setAttribute("layout", layout);
        this.processRegistry.associateProcessWithResource(subProcess, this.repositoryId);
        engine.startProcess(subProcess);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        this.setExtraDescription(repositoryName);
    }

    public List<String> getFormatBlacklist() {
        return this.formatBlacklist;
    }

    public void setFormatBlacklist(List<String> formatBlacklist) {
        this.formatBlacklist = formatBlacklist;
    }

    public Graph getSubGraph() {
        return this.subGraph;
    }

    @Required
    public void setSubGraph(Graph subGraph) {
        this.subGraph = subGraph;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public GraphProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    public void setProcessRegistry(GraphProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }
}

