/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.load.SarasvatiLoadException;
import com.googlecode.sarasvati.load.definition.ProcessDefinition;
import com.googlecode.sarasvati.xml.XmlLoader;
import com.googlecode.sarasvati.xml.XmlProcessDefinition;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ReindexAllWorkflowGenerator {
    private static final Log log = LogFactory.getLog(ReindexAllWorkflowGenerator.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private transient Engine engine;
    private String workflowName = "reindexAllRepositories";
    @Resource
    private SplittedQueryExecutor splittedQueryExecutor;
    private int limit = 0;

    public Graph generateGraph() throws JAXBException, SarasvatiLoadException {
        XmlLoader xmlLoader = new XmlLoader(new String[0]);
        try {
            File file = File.createTempFile("sara", "wf");
            String wfs = this.generateWorkflowSource(this.workflowName, this.getAllRepositories());
            FileWriter fw = new FileWriter(file);
            fw.write(wfs);
            fw.close();
            XmlProcessDefinition xmlDef = xmlLoader.translate(file);
            this.engine.getLoader().loadDefinition((ProcessDefinition)xmlDef);
            return this.engine.getRepository().getLatestGraph(this.workflowName);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Iterable<RepoDesc> getAllRepositories() {
        String query = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/RESOURCE_PROFILE order by xs:dateTime($x//DATE_OF_CREATION/@value/string()) return concat($x//RESOURCE_IDENTIFIER/@value/string(), ':-:', $x//OFFICIAL_NAME)";
        Iterable res = this.splittedQueryExecutor.query(RepoDesc.class, "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/RESOURCE_PROFILE order by xs:dateTime($x//DATE_OF_CREATION/@value/string()) return concat($x//RESOURCE_IDENTIFIER/@value/string(), ':-:', $x//OFFICIAL_NAME)");
        if (this.limit == 0) {
            return res;
        }
        ArrayList tmp = Lists.newArrayList((Iterable)res);
        return tmp.subList(0, Math.min(tmp.size(), this.limit));
    }

    public String generateWorkflowSource(String wfName, Iterable<RepoDesc> repositories) {
        StringBuilder builder = new StringBuilder();
        builder.append("<process-definition name=\"" + wfName + "\" xmlns=\"http://sarasvati.googlecode.com/ProcessDefinition\">\n");
        builder.append(" <node name=\"start\" isStart=\"true\">\n");
        builder.append("  <arc to=\"check_0\" />\n");
        builder.append(" </node>\n");
        this.generateWorkflowBody(builder, repositories);
        builder.append(" <node name=\"success\" type=\"Success\"/>\n");
        builder.append("</process-definition>\n");
        log.warn((Object)builder.toString());
        return builder.toString();
    }

    public void generateWorkflowBody(StringBuilder builder, Iterable<RepoDesc> repositories) {
        int current = 0;
        for (RepoDesc r : repositories) {
            builder.append(" <node name=\"check_" + current + "\" type=\"CheckRepositoryReindexJob\">\n");
            builder.append("  <arc to=\"feed_" + current + "\" />\n");
            builder.append("  <arc name=\"skip\" to=\"check_" + (current + 1) + "\" />\n");
            builder.append("  <custom>\n");
            builder.append("    <repositoryId>" + r.getId() + "</repositoryId>\n");
            builder.append("    <repositoryName>" + r.getName() + "</repositoryName>\n");
            builder.append("  </custom>\n");
            builder.append(" </node>\n");
            builder.append(" <node name=\"feed_" + current + "\" type=\"RepositoryReindexJob\">\n");
            builder.append("  <arc to=\"check_" + (current + 1) + "\" />\n");
            builder.append("  <custom>\n");
            builder.append("    <repositoryId>" + r.getId() + "</repositoryId>\n");
            builder.append("    <repositoryName>" + r.getName() + "</repositoryName>\n");
            builder.append("  </custom>\n");
            builder.append(" </node>\n");
            ++current;
        }
        builder.append(" <node name=\"check_" + current + "\">\n");
        builder.append("  <arc to=\"success\" />\n");
        builder.append(" </node>\n");
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public SplittedQueryExecutor getSplittedQueryExecutor() {
        return this.splittedQueryExecutor;
    }

    public void setSplittedQueryExecutor(SplittedQueryExecutor splittedQueryExecutor) {
        this.splittedQueryExecutor = splittedQueryExecutor;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public static class RepoDesc {
        private String id;
        private String name;

        public RepoDesc(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

