/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.CountingResultSetFactory;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.soap.cxf.CxfEndpointReferenceBuilder;
import eu.dnetlib.workflow.BlackboardJobNode;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class RefreshIndexJob
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(RefreshIndexJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource(name="cxfEndpointReferenceBuilder")
    private CxfEndpointReferenceBuilder eprBuilder;
    private XSLTMappedResultSetFactory xsltRSFactory;
    private CountingResultSetFactory countingRSFactory;
    private DataSourceResolver dataSourceResolver;
    private org.springframework.core.io.Resource layoutToRecordStylesheet;
    private String feedingType = "REFRESH";

    @Override
    protected String locateService(NodeToken token) {
        String indexId = token.getEnv().getAttribute("id");
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'IndexServiceResourceType' and .//RESOURCE_URI/@value = //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + indexId + "']//RESOURCE_URI/@value]//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        String indexId = token.getEnv().getAttribute("id");
        try {
            W3CEndpointReference mdStoreRsetEpr = this.dataSourceResolver.resolve(token.getFullEnv().getAttribute("dataSource")).retrieve();
            String format = token.getFullEnv().getAttribute("format");
            String layout = token.getFullEnv().getAttribute("layout");
            W3CEndpointReference rsetEpr = this.prepareForIndexing(mdStoreRsetEpr, format, layout);
            log.info((Object)("preparing index feeding: " + indexId));
            super.prepareJob(job, token);
            job.setAction("FEED");
            job.getParameters().put("feeding_type", this.feedingType);
            job.getParameters().put("resultset_epr", new String(Base64.encodeBase64((byte[])rsetEpr.toString().getBytes("US-ASCII")), "US-ASCII"));
            job.getParameters().put("id", indexId);
        }
        catch (ISLookUpException e) {
            log.fatal((Object)"problem looking up mdstore address during index feed", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (DataSinkSourceException e) {
            log.fatal((Object)"problem fetching mdstore stuff during index feed", (Throwable)e);
            throw new IllegalStateException("problem fetching mdstore content during index feed", e);
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"encoding problem in base64", (Throwable)e);
            throw new IllegalStateException("encoding problem in base64", e);
        }
        catch (IOException e) {
            log.fatal((Object)"problem loading xslt", (Throwable)e);
            throw new IllegalStateException("problem loading xslt", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException("problem creating xslt transformer", e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("problem creating xslt", e);
        }
    }

    protected W3CEndpointReference prepareForIndexing(W3CEndpointReference mdStoreRsetEpr, String format, String layout) throws ISLookUpException, IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer layoutTransformer = factory.newTransformer(new StreamSource(this.layoutToRecordStylesheet.getInputStream()));
        DOMResult layoutToXsltXslt = new DOMResult();
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(this.getLayoutSource(format, layout))), layoutToXsltXslt);
        this.dumpXslt(factory, layoutToXsltXslt);
        W3CEndpointReference xsltMapped = this.xsltRSFactory.createMappedResultSet(mdStoreRsetEpr, (Source)new DOMSource(layoutToXsltXslt.getNode()), "dynamic layout xslt for " + format + ", " + layout);
        return this.countingRSFactory.createCountingResultSet(xsltMapped);
    }

    private String getLayoutSource(String format, String layout) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + format + "']//LAYOUT[@name='" + layout + "']");
    }

    private void dumpXslt(TransformerFactory factory, DOMResult layoutToXsltXslt) throws TransformerConfigurationException, TransformerException {
        if (log.isDebugEnabled()) {
            StringWriter buffer = new StringWriter();
            factory.newTransformer().transform(new DOMSource(layoutToXsltXslt.getNode()), new StreamResult(buffer));
            log.debug((Object)buffer.toString());
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public CxfEndpointReferenceBuilder getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(CxfEndpointReferenceBuilder eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public XSLTMappedResultSetFactory getXsltRSFactory() {
        return this.xsltRSFactory;
    }

    @Required
    public void setXsltRSFactory(XSLTMappedResultSetFactory xsltRSFactory) {
        this.xsltRSFactory = xsltRSFactory;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public org.springframework.core.io.Resource getLayoutToRecordStylesheet() {
        return this.layoutToRecordStylesheet;
    }

    @Required
    public void setLayoutToRecordStylesheet(org.springframework.core.io.Resource layoutToRecordStylesheet) {
        this.layoutToRecordStylesheet = layoutToRecordStylesheet;
    }

    public CountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    @Required
    public void setCountingRSFactory(CountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }

    public String getFeedingType() {
        return this.feedingType;
    }

    public void setFeedingType(String feedingType) {
        this.feedingType = feedingType;
    }
}

