/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.wf.SinkSourceParser;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.NodeList;

public class MDStoreVerifyJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(MDStoreVerifyJobNode.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String mdstoreXPath;
    private String inputAttribute = "hiId";
    private SinkSourceParser sinkSourceParser;

    public void execute(Engine engine, NodeToken token) {
        try {
            String hiBody = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(token.getEnv().getAttribute(this.getInputAttribute()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.defineFunctions(xpath);
            String descriptor = xpath.evaluate(this.mdstoreXPath, new StringOpaqueResource(hiBody).asDom());
            String mdId = descriptor.startsWith("dnet:") ? this.sinkSourceParser.getId(descriptor) : descriptor;
            log.info((Object)("verifying mdstore " + mdId));
            try {
                ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(mdId);
                engine.complete(token, Arc.DEFAULT_ARC);
            }
            catch (ISLookUpDocumentNotFoundException e) {
                engine.complete(token, "notFound");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("problem parsing harvesting instance", e);
        }
    }

    private void defineFunctions(XPath xpath) {
        xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

            @Override
            public XPathFunction resolveFunction(QName name, int arity) {
                if (name.getNamespaceURI().equals("str") && name.getLocalPart().equals("replace")) {
                    return new XPathFunction(){

                        public Object evaluate(List args) throws XPathFunctionException {
                            String txt = ((NodeList)args.get(0)).item(0).getTextContent();
                            return txt.replaceAll((String)args.get(1), (String)args.get(2));
                        }
                    };
                }
                return null;
            }
        });
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getMdstoreXPath() {
        return this.mdstoreXPath;
    }

    public void setMdstoreXPath(String mdstoreXPath) {
        this.mdstoreXPath = mdstoreXPath;
    }

    public String getInputAttribute() {
        return this.inputAttribute;
    }

    public void setInputAttribute(String inputAttribute) {
        this.inputAttribute = inputAttribute;
    }

    public SinkSourceParser getSinkSourceParser() {
        return this.sinkSourceParser;
    }

    @Required
    public void setSinkSourceParser(SinkSourceParser sinkSourceParser) {
        this.sinkSourceParser = sinkSourceParser;
    }
}

