/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.AbstractBlackboardWorkflowJobListener;
import eu.dnetlib.workflow.BlackboardJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MDStoreBlackboardJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(MDStoreBlackboardJobNode.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String format;
    private String interpretation;
    private String layout;
    private String formatAttributeName;

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        log.info((Object)("preparing blackboard job: " + this.getFormat()));
        super.prepareJob(job, token);
        job.setAction("CREATE");
        Env env = token.getEnv();
        String envFormat = env.getAttribute(this.formatAttributeName);
        if (envFormat != null && !envFormat.isEmpty()) {
            this.format = envFormat;
        }
        job.getParameters().put("format", this.getFormat());
        job.getParameters().put("interpretation", this.getInterpretation());
        job.getParameters().put("layout", this.getLayout());
    }

    protected String readFormatFromEnv(Env env) {
        return env.getAttribute(this.formatAttributeName);
    }

    @Override
    protected AbstractBlackboardWorkflowJobListener createJobListener(Engine engine, NodeToken token) {
        AbstractBlackboardWorkflowJobListener jobListener = super.createJobListener(engine, token);
        return jobListener;
    }

    @Override
    protected String locateService() {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('/db/DRIVER/ServiceResources/MDStoreServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    @Override
    protected String getAttributePrefix() {
        return this.getFormat() + "_" + this.getInterpretation();
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getFormatAttributeName() {
        return this.formatAttributeName;
    }

    public void setFormatAttributeName(String formatAttributeName) {
        this.formatAttributeName = formatAttributeName;
    }
}

