/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.manager.msro.wf.CleanupJobNode;
import eu.dnetlib.enabling.tools.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class InvalidateRepositoryJob
extends CleanupJobNode {
    private static final Log log = LogFactory.getLog(InvalidateRepositoryJob.class);
    private ServiceLocator<ISRegistryService> registryLocator;
    private String repoAttrName;

    @Override
    public void execute(Engine engine, NodeToken token) {
        if (this.isInvalidated(token)) {
            super.execute(engine, token);
            return;
        }
        log.info((Object)("GOT repoid " + token.getFullEnv().getAttribute(this.repoAttrName)));
        try {
            ((ISRegistryService)this.registryLocator.getService()).invalidateProfile(token.getFullEnv().getAttribute(this.repoAttrName));
            this.setInvalidated(token, true);
            super.execute(engine, token);
        }
        catch (ISRegistryException e) {
            this.failed(engine, token, e);
        }
        log.info((Object)("END INVALIDATING " + (Object)((Object)this) + ", " + token));
    }

    public boolean isInvalidated(NodeToken token) {
        return "true".equals(token.getProcess().getEnv().getAttribute("invalidated"));
    }

    public void setInvalidated(NodeToken token, boolean invalidated) {
        token.getProcess().getEnv().setAttribute("invalidated", (Object)true);
    }

    public String getRepoAttrName() {
        return this.repoAttrName;
    }

    @Required
    public void setRepoAttrName(String repoAttrName) {
        this.repoAttrName = repoAttrName;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

