/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class HIJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(HIJobNode.class);
    private StringTemplate hiTemplate;
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String harvestingFormat;
    private String aggregatingFormat;

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)"CREATING HI");
        token.getEnv().setAttribute("isBlackboard", (Object)false);
        StringTemplate template = new StringTemplate(this.hiTemplate.getTemplate());
        Env env = token.getFullEnv();
        for (String key : env.getAttributeNames()) {
            template.setAttribute(key, (Object)env.getAttribute(key));
        }
        template.setAttribute("harvesting_format", (Object)this.harvestingFormat);
        template.setAttribute("aggregating_format", (Object)this.aggregatingFormat);
        String harvestingId = token.getEnv().getAttribute(this.harvestingFormat + "_id");
        template.setAttribute("harvesting_id", (Object)harvestingId);
        try {
            template.setAttribute("harvesting_uri", (Object)((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value/string() = '" + harvestingId + "']//RESOURCE_URI/@value/string()"));
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("cannot find mdstore uri for mdstore " + harvestingId, e);
        }
        if ("".equals(harvestingId)) {
            throw new IllegalStateException("cannot find mdstore uri for harvesting mdstore " + this.harvestingFormat);
        }
        String aggregatingId = token.getEnv().getAttribute(this.aggregatingFormat + "_id");
        template.setAttribute("aggregating_id", (Object)aggregatingId);
        try {
            template.setAttribute("aggregating_uri", (Object)((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value/string() = '" + aggregatingId + "']//RESOURCE_URI/@value/string()"));
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("cannot find mdstore uri for mdstore " + aggregatingId, e);
        }
        if ("".equals(aggregatingId)) {
            throw new IllegalStateException("cannot find mdstore uri for aggregating mdstore " + this.aggregatingFormat);
        }
        log.debug((Object)("HI: " + template));
        try {
            String hiId = ((ISRegistryService)this.registryLocator.getService()).registerProfile(template.toString());
            log.info((Object)("HI created: " + hiId));
            token.getEnv().setAttribute("hiId", hiId);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISRegistryException e) {
            log.fatal((Object)"CANNOT REGISTER HI", (Throwable)e);
            engine.complete(token, "failed");
        }
        catch (RuntimeException e) {
            log.fatal((Object)"CANNOT REGISTER HI", (Throwable)e);
            engine.complete(token, "failed");
            throw e;
        }
    }

    public StringTemplate getHiTemplate() {
        return this.hiTemplate;
    }

    @Required
    public void setHiTemplate(StringTemplate hiTemplate) {
        this.hiTemplate = hiTemplate;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getHarvestingFormat() {
        return this.harvestingFormat;
    }

    @Required
    public void setHarvestingFormat(String harvestingFormat) {
        this.harvestingFormat = harvestingFormat;
    }

    public String getAggregatingFormat() {
        return this.aggregatingFormat;
    }

    @Required
    public void setAggregatingFormat(String aggregatingFormat) {
        this.aggregatingFormat = aggregatingFormat;
    }
}

