/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HIForRepositoryJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(HIForRepositoryJobNode.class);
    private ServiceLocator<ISLookUpService> lookupLocator;

    public void execute(Engine engine, NodeToken token) {
        String repoId = token.getFullEnv().getAttribute("repositoryId");
        log.info((Object)("FINDING HI for repository " + repoId));
        try {
            String hiId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//REPOSITORY_SERVICE_IDENTIFIER = '" + repoId + "']//RESOURCE_IDENTIFIER/@value/string()");
            token.getEnv().setAttribute("hiId", hiId);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISLookUpException e) {
            token.getEnv().setAttribute("hasFailed", (Object)true);
            token.getEnv().setAttribute("errorMessage", "cannot find harvesting instance for repository " + repoId);
            engine.complete(token, "failed");
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

