/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class GetRepositoryFormatJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(GetRepositoryFormatJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String formatAttributeName;

    public void execute(Engine engine, NodeToken token) {
        log.debug((Object)this);
        Env env = token.getFullEnv();
        String repositoryFormat = null;
        try {
            repositoryFormat = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value ='" + env.getAttribute("repositoryId") + "']//INTERFACES/INTERFACE/FORMATS/FORMAT/string()").get(0);
            log.debug((Object)("found repository format : " + repositoryFormat));
            if (repositoryFormat != null && !repositoryFormat.isEmpty()) {
                env.setAttribute(this.formatAttributeName, repositoryFormat);
                engine.complete(token, Arc.DEFAULT_ARC);
            } else {
                this.failed(engine, token, new RuntimeException("Missing required field FORMAT in repository profile"));
            }
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public void setFormatAttributeName(String formatAttributeName) {
        this.formatAttributeName = formatAttributeName;
    }

    public String getFormatAttributeName() {
        return this.formatAttributeName;
    }
}

