/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.ManagerMap;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FindIndexJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(FindIndexJob.class);
    private ManagerMap managerMap;
    private String mdFormat;
    private String layout;
    private String interpretation;

    public void execute(Engine engine, NodeToken token) {
        String mdId = token.getFullEnv().getAttribute("mdId");
        String envFormat = token.getFullEnv().getAttribute("format");
        String envLayout = token.getFullEnv().getAttribute("layout");
        String envInterpretation = token.getFullEnv().getAttribute("interpretation");
        log.info((Object)("searching index for mdstore " + mdId));
        String format = this.handleOverride(token, "format", envFormat, this.getMdFormat());
        String layout = this.handleOverride(token, "layout", envLayout, this.getLayout());
        String interp = this.handleOverride(token, "interpretation", envInterpretation, this.getInterpretation());
        String indexId = this.managerMap.indexForMDStore(mdId, format, layout, interp);
        token.getEnv().setAttribute("id", indexId);
        if (indexId == null || indexId.isEmpty()) {
            engine.complete(token, "notFound");
        } else {
            engine.complete(token, "found");
        }
    }

    private String handleOverride(NodeToken token, String name, String env, String override) {
        if (override != null) {
            token.getEnv().setAttribute(name, override);
        }
        return override != null ? override : env;
    }

    public ManagerMap getManagerMap() {
        return this.managerMap;
    }

    @Required
    public void setManagerMap(ManagerMap managerMap) {
        this.managerMap = managerMap;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }
}

