/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteIndexJob
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(DeleteIndexJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;

    @Override
    protected String locateService(NodeToken token) {
        String indexId = token.getFullEnv().getAttribute("id");
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'IndexServiceResourceType' and .//RESOURCE_URI/@value = //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + indexId + "']//RESOURCE_URI/@value]//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
        }
        catch (ISLookUpException e) {
            log.warn((Object)("cannot find service for index " + indexId), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        log.info((Object)"preparing index deletion blackboard job");
        super.prepareJob(job, token);
        job.setAction("DELETE");
        String indexId = token.getFullEnv().getAttribute("id");
        job.getParameters().put("id", indexId);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

