/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

public class DeleteHIJobNode
extends AbstractJobNode {
    private ServiceLocator<ISRegistryService> registryLocator;
    private String inputAttribute = "hiId";

    public void execute(Engine engine, NodeToken token) {
        String hiId = token.getFullEnv().getAttribute(this.getInputAttribute());
        try {
            ((ISRegistryService)this.registryLocator.getService()).deleteProfile(hiId);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISRegistryException e) {
            token.getEnv().setAttribute("hasFailed", (Object)true);
            token.getEnv().setAttribute("errorMessage", "cannot find harvesting instance for repository " + hiId + ": " + (Object)((Object)e));
            engine.complete(token, "failed");
        }
    }

    public String getInputAttribute() {
        return this.inputAttribute;
    }

    public void setInputAttribute(String inputAttribute) {
        this.inputAttribute = inputAttribute;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

