/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.collections.EnsureCollection;
import eu.dnetlib.workflow.BlackboardJobNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DataManagerServiceJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(DataManagerServiceJobNode.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<ISRegistryService> registryLocator;
    private AggregatorAction action;
    private String serviceName;
    private String bigServiceName;
    private String dsName;

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        log.info((Object)("preparing ds blackboard job: " + job + ", for " + this.getDsName()));
        String dsId = token.getEnv().getAttribute(this.getDsName());
        String serviceId = this.locateService(token);
        try {
            String query = "for $x in collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + dsId + "']]," + " $y in collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + serviceId + "']]" + " return (update value $x//" + this.getBigServiceName() + "_IDENTIFIER with $y//RESOURCE_IDENTIFIER/@value/string()," + "update value $x//" + this.getBigServiceName() + "_URI with $y//RESOURCE_URI/@value/string())";
            ((ISRegistryService)this.getRegistryLocator().getService()).executeXUpdate(query);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot put service identifier in ds instance", e);
        }
        super.prepareJob(job, token);
        job.setAction(this.getAction().toString());
        job.getParameters().put("id", dsId);
    }

    @Override
    protected String locateService(NodeToken token) {
        String repositoryId = token.getFullEnv().getAttribute("repositoryId");
        String query = "collection('/db/DRIVER/ServiceResources/" + this.getServiceName() + "ResourceType')//RESOURCE_PROFILE[.//PROPERTY[@key='name' and @value= //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + repositoryId + "']//FIELD[key='aggregatorName']/value ]]//RESOURCE_IDENTIFIER/@value/string()";
        try {
            List candidates = EnsureCollection.list((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query));
            if (candidates.isEmpty()) {
                String deletedQuery = "//RESOURCE_PROFILE[.//REPOSITORY_SERVICE_IDENTIFIER='" + repositoryId + "']//" + this.bigServiceName + "_IDENTIFIER/text()";
                List deletedCandidates = EnsureCollection.list((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(deletedQuery));
                if (deletedCandidates.isEmpty()) {
                    return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('/db/DRIVER/ServiceResources/" + this.getServiceName() + "ResourceType')//RESOURCE_PROFILE[.//PROPERTY[@key='name']/@value = 'DRIVER']//RESOURCE_IDENTIFIER/@value/string()");
                }
                return (String)deletedCandidates.get(0);
            }
            return (String)candidates.get(0);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("searching for " + query, e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public AggregatorAction getAction() {
        return this.action;
    }

    public void setAction(AggregatorAction action) {
        this.action = action;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Required
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getDsName() {
        return this.dsName;
    }

    @Required
    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getBigServiceName() {
        return this.bigServiceName;
    }

    @Required
    public void setBigServiceName(String bigServiceName) {
        this.bigServiceName = bigServiceName;
    }

    public static enum AggregatorAction {
        MANAGE,
        RELEASE;

    }
}

