/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.ManagerMap;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateIndexJob
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(CreateIndexJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private ManagerMap managerMap;

    @Override
    protected String locateService() {
        return this.managerMap.getMasterIndexService();
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        log.info((Object)"preparing index creation blackboard job");
        super.prepareJob(job, token);
        job.setAction("CREATE");
        String format = token.getFullEnv().getAttribute("format");
        String interpretation = token.getFullEnv().getAttribute("interpretation");
        String layout = token.getFullEnv().getAttribute("layout");
        job.getParameters().put("format", format);
        job.getParameters().put("interpretation", interpretation);
        job.getParameters().put("layout", layout);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ManagerMap getManagerMap() {
        return this.managerMap;
    }

    public void setManagerMap(ManagerMap managerMap) {
        this.managerMap = managerMap;
    }
}

