/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CheckRepositoryReindexJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(CheckRepositoryReindexJob.class);
    private String repositoryId;
    private String repositoryName;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<ISRegistryService> registryLocator;

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)("executing " + (Object)((Object)this) + " repo: " + this.repositoryName));
        try {
            String query = "let $m := //REPOSITORY_SERVICE_IDENTIFIER[. = '" + this.repositoryId + "']/../..//AGGREGATING_UNIT/MDSTORE_DS_IDENTIFIER/text()," + " $i := //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ManagerServiceMapDSResourceType']//MDSTORE[@id=$m]/../@id/string()," + " $ip := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $i]," + " $mp := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $m]" + " return //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = $m]//NUMBER_OF_RECORDS > 0 and $ip and" + "   xs:dateTime($mp//LAST_STORAGE_DATE) > xs:dateTime($ip//INDEX_LAST_UPDATE)";
            String hasData = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            this.updateRepositoryDate();
            if (Boolean.parseBoolean(hasData)) {
                engine.complete(token, Arc.DEFAULT_ARC);
            } else {
                engine.complete(token, "skip");
            }
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    private void updateRepositoryDate() {
        try {
            String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(this.repositoryId);
            ((ISRegistryService)this.registryLocator.getService()).updateProfile(this.repositoryId, profile, "RepositoryServiceResourceType");
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        this.setExtraDescription(repositoryName);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

