/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class AggregatorHIJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(AggregatorHIJobNode.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<ISRegistryService> registryLocator;
    private AggregatorAction action;

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) {
        log.info((Object)("preparing blackboard job: " + job));
        String aggregatorId = this.locateService();
        String hiId = token.getEnv().getAttribute("hiId");
        try {
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate("for $x in collection('')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER[@value='" + hiId + "']]" + "return update value $x//AGGREGATOR_SERVICE_IDENTIFIER with '" + aggregatorId + "'");
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot put aggregator service identifier in harvestin instance", e);
        }
        super.prepareJob(job, token);
        job.setAction(this.getAction().toString());
        job.getParameters().put("id", hiId);
    }

    @Override
    protected String locateService() {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('/db/DRIVER/ServiceResources/AggregatorServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public AggregatorAction getAction() {
        return this.action;
    }

    public void setAction(AggregatorAction action) {
        this.action = action;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public static enum AggregatorAction {
        MANAGE,
        RELEASE;

    }
}

