/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.wf;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractDataDSJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(AbstractDataDSJobNode.class);
    private StringTemplate dsTemplate;
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected abstract String getDSType();

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)("CREATING " + this.getDSType()));
        token.getEnv().setAttribute("isBlackboard", (Object)false);
        StringTemplate template = new StringTemplate(this.dsTemplate.getTemplate());
        Env env = token.getFullEnv();
        for (String key : env.getAttributeNames()) {
            template.setAttribute(key, (Object)env.getAttribute(key));
        }
        this.prepareParameters(template, env);
        log.debug((Object)(this.getDSType() + ": " + template));
        try {
            String dataDsId = ((ISRegistryService)this.registryLocator.getService()).registerProfile(template.toString());
            log.info((Object)(this.getDSType() + " created: " + dataDsId));
            token.getEnv().setAttribute("dataDsId", dataDsId);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISRegistryException e) {
            log.fatal((Object)("CANNOT REGISTER " + this.getDSType()), (Throwable)e);
            engine.complete(token, "failed");
        }
        catch (RuntimeException e) {
            log.fatal((Object)("CANNOT REGISTER " + this.getDSType()), (Throwable)e);
            engine.complete(token, "failed");
            throw e;
        }
    }

    protected abstract void prepareParameters(StringTemplate var1, Env var2);

    public StringTemplate getDsTemplate() {
        return this.dsTemplate;
    }

    @Required
    public void setDsTemplate(StringTemplate dsTemplate) {
        this.dsTemplate = dsTemplate;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

