/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro;

import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class XUpdateReactor
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(XUpdateReactor.class);
    private String xupdate;
    private Resource xupdateExternal;
    private ServiceLocator<ISRegistryService> registryLocator;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        if (!topic.startsWith(this.getTopicPrefix())) {
            return;
        }
        try {
            if (this.xupdate != null) {
                this.executeXUpdate(this.xupdate);
            } else {
                StringWriter buffer = new StringWriter();
                IOUtils.copy((InputStream)this.xupdateExternal.getInputStream(), (Writer)buffer);
                this.executeXUpdate(buffer.toString());
            }
        }
        catch (IOException e) {
            log.fatal((Object)"failed to execute xupdate", (Throwable)e);
        }
        catch (ISRegistryException e) {
            log.fatal((Object)"failed to execute xupdate", (Throwable)e);
        }
    }

    private void executeXUpdate(String source) throws ISRegistryException {
        log.debug((Object)("executing " + source));
        ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(source);
    }

    public String getXupdate() {
        return this.xupdate;
    }

    public void setXupdate(String xupdate) {
        this.xupdate = xupdate;
    }

    public Resource getXupdateExternal() {
        return this.xupdateExternal;
    }

    public void setXupdateExternal(Resource xupdateExternal) {
        this.xupdateExternal = xupdateExternal;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

