/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.enabling.inspector.msro.AjaxProcessGraphGenerator;
import eu.dnetlib.enabling.inspector.msro.ProcessListEntry;
import eu.dnetlib.enabling.manager.msro.rmi.MSROService;
import eu.dnetlib.enabling.manager.msro.rmi.ProcessCompletionStatus;
import eu.dnetlib.enabling.manager.msro.rmi.ProcessDescription;
import eu.dnetlib.enabling.manager.msro.rmi.ProcessStatus;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.CompositeUnaryFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MSROServiceImpl
extends AbstractBaseService
implements MSROService {
    private static final Log log = LogFactory.getLog(MSROServiceImpl.class);
    private AjaxProcessGraphGenerator graphGenerator;
    private NotificationHandler notificationHandler;
    private GraphProcessRegistry processRegistry;

    public void notify(String subscriptionId, String topic, String isId, String message) {
        super.notify(subscriptionId, topic, isId, message);
        log.debug((Object)("got notification: " + topic));
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public List<ProcessDescription> listOrchestrationProcesses(String rsId, int maxProcesses) {
        UnaryFunction<ProcessDescription, String> convert = new UnaryFunction<ProcessDescription, String>(){

            public ProcessDescription evaluate(String pid) {
                return MSROServiceImpl.this.makeProcessDescription(pid, MSROServiceImpl.this.processRegistry.findProcess(pid));
            }
        };
        ArrayList processes = null;
        if (rsId == null || rsId.trim().isEmpty()) {
            processes = Lists.newArrayList((Iterable)new MappedCollection(this.processRegistry.listIdentifiers(), (UnaryFunction)convert));
        } else {
            UnaryFunction<String, GraphProcess> retrieveIds = new UnaryFunction<String, GraphProcess>(){

                public String evaluate(GraphProcess process) {
                    return MSROServiceImpl.this.processRegistry.getProcessIdentifier(process);
                }
            };
            processes = Lists.newArrayList((Iterable)new MappedCollection(this.processRegistry.findProcessesByResource(rsId), (UnaryFunction)new CompositeUnaryFunction((UnaryFunction)convert).of((UnaryFunction)retrieveIds)));
        }
        Collections.sort(processes);
        return processes;
    }

    private ProcessDescription makeProcessDescription(String pid, GraphProcess process) {
        ProcessStatus status;
        ProcessListEntry entry = new ProcessListEntry(pid, process);
        switch (process.getState()) {
            case Executing: {
                status = ProcessStatus.RUNNING;
                break;
            }
            case Completed: {
                status = ProcessStatus.COMPLETED;
                break;
            }
            case Canceled: {
                status = ProcessStatus.CANCELED;
                break;
            }
            default: {
                status = ProcessStatus.UNKNOWN;
            }
        }
        ProcessDescription desc = new ProcessDescription(pid, process.getGraph().getName(), status, entry.getLatestActivity());
        desc.setCompletionStatus(this.obtainCompletionStatus(process));
        return desc;
    }

    private ProcessCompletionStatus obtainCompletionStatus(GraphProcess process) {
        if (!process.isComplete()) {
            return ProcessCompletionStatus.UNKNOWN;
        }
        if ("true".equals(process.getEnv().getAttribute("isCompletedSuccessfully"))) {
            return ProcessCompletionStatus.SUCCESS;
        }
        return ProcessCompletionStatus.FAILURE;
    }

    public String processHtmlMap(String pid) {
        return this.graphGenerator.generateMapHtml(pid);
    }

    @Required
    public void setNotificationHandler(NotificationHandler notHandler) {
        this.notificationHandler = notHandler;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public AjaxProcessGraphGenerator getGraphGenerator() {
        return this.graphGenerator;
    }

    @Required
    public void setGraphGenerator(AjaxProcessGraphGenerator graphGenerator) {
        this.graphGenerator = graphGenerator;
    }

    public GraphProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    @Required
    public void setProcessRegistry(GraphProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }
}

