/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.manager.msro.ManagerMap;
import eu.dnetlib.enabling.tools.ServiceLocator;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ISManagerMapImpl
implements ManagerMap {
    private static final Log log = LogFactory.getLog(ISManagerMapImpl.class);
    private ServiceLocator<ISLookUpService> lookUpLocator;
    private ServiceLocator<ISRegistryService> registryLocator;
    private StringTemplate emptyMapTemplate;

    @Override
    public String indexForMDStore(String mdId, String format, String layout, String interpretation) {
        try {
            this.ensureMapExists();
            String query = "collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')//INDEX_MAP/INDEX[MDSTORE/@id='" + mdId + "' and @format = '" + format + "' and @layout = '" + layout + "' and @interpretation = '" + interpretation + "']/@id/string()";
            return ((ISLookUpService)this.lookUpLocator.getService()).getResourceProfileByQuery(query);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void registerIndexForMDStore(String mdId, String indexId, String format, String layout, String interpretation) {
        try {
            this.ensureMapExists();
            String xupdate = "for $x in collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')//INDEX_MAP return update insert <INDEX format=\"" + format + "\" layout=\"" + layout + "\" interpretation=\"" + interpretation + "\" parentId=\"\" hiId=\"\" id=\"" + indexId + "\">" + "<MDSTORE parentId=\"\" id=\"" + mdId + "\"/>" + "</INDEX> into $x";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xupdate);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void removeIndex(String indexId) {
        try {
            String xupdate = "for $x in collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')//INDEX_MAP return update delete $x//INDEX[@id = '" + indexId + "']";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xupdate);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void removeMDStore(String mdId) {
        try {
            String xupdate = "for $x in collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')//INDEX_MAP return update delete $x//INDEX[MDSTORE[@id = '" + mdId + "']]";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xupdate);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void ensureMapExists() throws ISLookUpException, ISRegistryException {
        this.ensureMapExistsWithMaster(null);
    }

    protected void ensureMapExistsWithMaster(String candidateMaster) throws ISLookUpException, ISRegistryException {
        String master;
        log.debug((Object)("ENSURING MAP EXISTS: " + candidateMaster));
        try {
            ((ISLookUpService)this.lookUpLocator.getService()).getResourceProfileByQuery("collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            ((ISRegistryService)this.registryLocator.getService()).registerProfile(this.emptyMapTemplate.toString());
        }
        try {
            master = ((ISLookUpService)this.lookUpLocator.getService()).getResourceProfileByQuery("string(collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')//MASTER_INDEX)");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            master = "";
        }
        log.debug((Object)("MASTER WAS: " + master));
        if (master.isEmpty()) {
            this.setMasterIndexService(candidateMaster == null ? this.electMasterIndexService() : candidateMaster);
        }
    }

    @Override
    public void offerMasterIndexService(String id) {
        try {
            this.ensureMapExistsWithMaster(id);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    private String electMasterIndexService() {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'IndexServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookUpLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'IndexServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getMasterIndexService() {
        try {
            return ((ISLookUpService)this.lookUpLocator.getService()).getResourceProfileByQuery("collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType')//MASTER_INDEX/text()");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setMasterIndexService(String id) {
        log.debug((Object)("SETTING MASTER TO: " + id));
        String indexServiceId = id == null ? "" : id;
        try {
            String xupdate = "for $x in collection('/db/DRIVER/ManagerServiceMapDSResources/ManagerServiceMapDSResourceType') return update value $x//MASTER_INDEX with '" + indexServiceId + "'";
            log.debug((Object)xupdate);
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(xupdate);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookUpLocator() {
        return this.lookUpLocator;
    }

    @Required
    public void setLookUpLocator(ServiceLocator<ISLookUpService> lookUpLocator) {
        this.lookUpLocator = lookUpLocator;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public StringTemplate getEmptyMapTemplate() {
        return this.emptyMapTemplate;
    }

    @Required
    public void setEmptyMapTemplate(StringTemplate emptyMapTemplate) {
        this.emptyMapTemplate = emptyMapTemplate;
    }
}

