/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro;

import com.googlecode.sarasvati.Graph;
import eu.dnetlib.enabling.manager.msro.ResourceToWorkflowMapper;
import eu.dnetlib.enabling.tools.OpaqueResource;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class ExtraPropertyResourceToWorkflowMapper
implements ResourceToWorkflowMapper {
    private static final Log log = LogFactory.getLog(ExtraPropertyResourceToWorkflowMapper.class);
    private Map<String, List<Graph>> graphMap;
    private String action;

    @Override
    public List<Graph> getWorkflowsForResource(OpaqueResource resource) {
        Document doc = resource.asDom();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            List<Graph> res;
            String val = xpath.evaluate("//EXTRA_FIELDS/FIELD[key='msroWorkflow-" + this.action + "']/value", doc);
            log.info((Object)("Found graph bean: " + val));
            if (val == null || val.equals("")) {
                val = "default";
            }
            if ((res = this.graphMap.get(val)) == null || res.isEmpty()) {
                return this.graphMap.get("default");
            }
            return res;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Cannot xpath on extra_fields", e);
        }
    }

    public Map<String, List<Graph>> getGraphMap() {
        return this.graphMap;
    }

    public void setGraphMap(Map<String, List<Graph>> graphMap) {
        this.graphMap = graphMap;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

