/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import com.googlecode.sarasvati.mem.MemGraphProcess;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.enabling.tools.EnableableEnumerator;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractWorkflowLauncherNotificationHandler
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(AbstractWorkflowLauncherNotificationHandler.class);
    private GraphProcessRegistry processRegistry;
    private Graph graph;
    @Resource
    private transient Engine engine;
    @Resource
    private EnableableEnumerator enableableEnumerator;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        if (!topic.startsWith(this.getTopicPrefix())) {
            return;
        }
        MemGraphProcess process = new MemGraphProcess(this.graph);
        this.processRegistry.associateProcessWithResource((GraphProcess)process, rsId);
        Env env = process.getEnv();
        env.setAttribute("enableableName", this.getEnableableName());
        log.info((Object)("Starting workflow process for " + this.getEnableableName()));
        try {
            this.prepareProcess((GraphProcess)process, env, rsId, profile);
        }
        catch (RuntimeException e) {
            env.setAttribute("hasFailed", (Object)true);
            env.setAttribute("errorMessage", e.getMessage());
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            env.setAttribute("errorDetails", stackTrace.toString());
            throw e;
        }
        this.engine.startProcess((GraphProcess)process);
    }

    public String getEnableableName() {
        for (Map.Entry entry : this.enableableEnumerator.getAllEnableables().entrySet()) {
            if (entry.getValue() != this) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    protected abstract void prepareProcess(GraphProcess var1, Env var2, String var3, String var4);

    public GraphProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    @Required
    public void setProcessRegistry(GraphProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public EnableableEnumerator getEnableableEnumerator() {
        return this.enableableEnumerator;
    }

    public void setEnableableEnumerator(EnableableEnumerator enableableEnumerator) {
        this.enableableEnumerator = enableableEnumerator;
    }
}

