/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro.progress;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.inspector.msro.progress.NoSuchProgressProviderException;
import eu.dnetlib.enabling.inspector.msro.progress.ProgressProvider;
import eu.dnetlib.enabling.inspector.msro.progress.SharedContextProgressProvider;
import eu.dnetlib.enabling.inspector.msro.progress.SharedContextProgressProviderFactory;
import org.springframework.beans.factory.annotation.Required;

public class SharedContextProgressProviderDispatcher
implements ProgressProvider {
    private SharedContextProgressProviderFactory factory;

    @Override
    public int getTotalValue(Node node, NodeToken token) {
        String key = token.getEnv().getAttribute("progressKey");
        return this.getProvider(key).getTotalValue(node, token);
    }

    @Override
    public int getCurrentValue(Node node, NodeToken token) {
        String key = token.getEnv().getAttribute("progressKey");
        return this.getProvider(key).getCurrentValue(node, token);
    }

    protected SharedContextProgressProvider getProvider(String key) {
        SharedContextProgressProvider provider = this.factory.find(key);
        if (provider == null) {
            throw new NoSuchProgressProviderException();
        }
        return provider;
    }

    @Override
    public boolean isInaccurate() {
        return true;
    }

    public SharedContextProgressProviderFactory getFactory() {
        return this.factory;
    }

    @Required
    public void setFactory(SharedContextProgressProviderFactory factory) {
        this.factory = factory;
    }
}

