/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro.progress;

import com.googlecode.sarasvati.NodeToken;
import com.sun.xml.messaging.saaj.util.Base64;
import eu.dnetlib.enabling.inspector.msro.progress.BlackboardProgressProvider;
import eu.dnetlib.enabling.resultset.CountingResultSet;
import eu.dnetlib.enabling.resultset.LocalResultSetImpl;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.ResultSetRegistry;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CountingResultsetProgressProvider
extends BlackboardProgressProvider {
    private static final Log log = LogFactory.getLog(CountingResultsetProgressProvider.class);
    private String resultsetAttribute;
    private boolean base64 = true;
    private ServiceResolver serviceResolver;
    private ResultSetRegistry resultSetRegistry;
    private int minimumSize = 0;
    private int lastTotal;

    public CountingResultSet preamble(AbstractJobNode node, NodeToken token) {
        if (token == null) {
            log.debug((Object)"token is null");
            return null;
        }
        return this.getCountingResultSet(node, token);
    }

    @Override
    public int getTotalValue(AbstractJobNode node, NodeToken token) {
        CountingResultSet counting = this.preamble(node, token);
        if (counting == null) {
            return 0;
        }
        int res = Math.max(this.minimumSize, counting.getSize());
        if (this.lastTotal > 0 && counting.getSize() > this.minimumSize && res > this.lastTotal) {
            this.setInaccurate(true);
        }
        this.lastTotal = res;
        return res;
    }

    @Override
    public int getCurrentValue(AbstractJobNode node, NodeToken token) {
        CountingResultSet counting = this.preamble(node, token);
        if (counting == null) {
            return 0;
        }
        return counting.getCount();
    }

    protected ResultSet getResultSet(String rsId) {
        return this.resultSetRegistry.getResultSetById(rsId);
    }

    protected CountingResultSet getCountingResultSet(AbstractJobNode node, NodeToken token) {
        return this.getCountingResultSet(this.getResultsetId(node, token));
    }

    protected CountingResultSet getCountingResultSet(String rsId) {
        return this.getCountingResultSet(this.getResultSet(rsId));
    }

    protected CountingResultSet getCountingResultSet(ResultSet rs) {
        ResultSetListener listener;
        if (rs instanceof LocalResultSetImpl && (listener = ((LocalResultSetImpl)rs).getListener()) instanceof CountingResultSet) {
            return (CountingResultSet)listener;
        }
        return null;
    }

    protected String getResultsetId(AbstractJobNode node, NodeToken token) {
        BlackboardJob job = (BlackboardJob)token.getEnv().getTransientAttribute("blackboardJob");
        if (job == null) {
            return null;
        }
        String attribute = (String)job.getParameters().get(this.resultsetAttribute);
        if (attribute == null) {
            return null;
        }
        String eprString = attribute;
        if (this.base64) {
            eprString = Base64.base64Decode((String)eprString);
        }
        return this.getResultsetId(eprString);
    }

    protected String getResultsetId(String eprString) {
        W3CEndpointReference epr = (W3CEndpointReference)W3CEndpointReference.readFrom((Source)new StreamSource(new StringReader(eprString)));
        return this.getResultsetId(epr);
    }

    protected String getResultsetId(W3CEndpointReference epr) {
        return this.serviceResolver.getResourceIdentifier(epr);
    }

    public String getResultsetAttribute() {
        return this.resultsetAttribute;
    }

    public void setResultsetAttribute(String resultsetAttribute) {
        this.resultsetAttribute = resultsetAttribute;
    }

    public ResultSetRegistry getResultSetRegistry() {
        return this.resultSetRegistry;
    }

    @Required
    public void setResultSetRegistry(ResultSetRegistry resultSetRegistry) {
        this.resultSetRegistry = resultSetRegistry;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int minimumSize) {
        this.minimumSize = minimumSize;
    }
}

