/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.tools.Schedulable;
import eu.dnetlib.enabling.tools.SchedulableEnumerator;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SchedulableController
extends AbstractInspectorController {
    @Resource
    private SchedulableEnumerator schedulableEnumerator;

    @RequestMapping(value={"/inspector/schedulables.do"}, method={RequestMethod.GET})
    public void enableables(Model model) {
        model.addAttribute("schedulables", this.schedulableEnumerator.getAllSchedulables().entrySet());
    }

    @RequestMapping(value={"/inspector/schedulables.do"}, method={RequestMethod.POST})
    public String updateCron(Model model, @RequestParam(value="bean", required=true) String name, @RequestParam(value="cron", required=true) String cron) {
        this.schedulableEnumerator.getSchedulable(name).updateCronExpression(cron);
        return "redirect:schedulables.do";
    }

    @RequestMapping(value={"/inspector/enableSchedulable.do"})
    public String enableBean(Model model, @RequestParam(value="name", required=true) String name) {
        Schedulable schedulable = this.schedulableEnumerator.getSchedulable(name);
        schedulable.setEnabled(true);
        return "redirect:schedulables.do";
    }

    @RequestMapping(value={"/inspector/disableSchedulable.do"})
    public String disableBean(Model model, @RequestParam(value="name", required=true) String name) {
        Schedulable schedulable = this.schedulableEnumerator.getSchedulable(name);
        schedulable.setEnabled(false);
        return "redirect:schedulables.do";
    }

    @RequestMapping(value={"/inspector/resumeSchedulable.do"})
    public String resume(Model model, @RequestParam(value="name", required=true) String name) {
        this.schedulableEnumerator.getSchedulable(name).resume();
        return "redirect:schedulables.do";
    }

    @RequestMapping(value={"/inspector/pauseSchedulable.do"})
    public String pause(Model model, @RequestParam(value="name", required=true) String name) {
        this.schedulableEnumerator.getSchedulable(name).pause();
        return "redirect:schedulables.do";
    }

    @RequestMapping(value={"/inspector/runSchedulable.do"})
    public String run(Model model, @RequestParam(value="name", required=true) String name) {
        this.schedulableEnumerator.getSchedulable(name).execute();
        return "redirect:schedulables.do";
    }
}

