/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.rmi.ProcessCompletionStatus;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProcessListEntry
implements Comparable<ProcessListEntry> {
    private String pid;
    private GraphProcess process;

    public ProcessListEntry(String pid, GraphProcess process) {
        this.pid = pid;
        this.process = process;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public Date getLatestActivityDate() {
        Date latestActivity = null;
        for (NodeToken token : this.process.getNodeTokens()) {
            Date activity = token.getCompleteDate();
            if (activity == null) {
                activity = token.getCreateDate();
            }
            if (latestActivity == null) {
                latestActivity = activity;
            }
            if (activity == null || latestActivity == null || activity.compareTo(latestActivity) <= 0) continue;
            latestActivity = activity;
        }
        return latestActivity;
    }

    public String getLatestActivity() {
        Date latestActivity = this.getLatestActivityDate();
        if (latestActivity == null) {
            return "not yet started";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(latestActivity);
    }

    public ProcessCompletionStatus getCompletionStatus() {
        if (!this.process.isComplete()) {
            return ProcessCompletionStatus.UNKNOWN;
        }
        if ("true".equals(this.process.getEnv().getAttribute("isCompletedSuccessfully"))) {
            return ProcessCompletionStatus.SUCCESS;
        }
        return ProcessCompletionStatus.FAILURE;
    }

    public GraphProcess getProcess() {
        return this.process;
    }

    public void setProcess(GraphProcess process) {
        this.process = process;
    }

    @Override
    public int compareTo(ProcessListEntry other) {
        Date thisDate = this.getLatestActivityDate();
        Date otherDate = other.getLatestActivityDate();
        if (thisDate == null) {
            thisDate = new Date(0L);
        }
        if (otherDate == null) {
            otherDate = new Date(0L);
        }
        return -thisDate.compareTo(otherDate);
    }
}

