/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.ProcessState;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.inspector.ResourceLinkTool;
import eu.dnetlib.enabling.inspector.msro.AbstractProcessGraphGenerator;
import eu.dnetlib.enabling.inspector.msro.ProcessListEntry;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.manager.msro.rmi.ProcessCompletionStatus;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardMessage;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.string.EscapeHtml;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import eu.dnetlib.workflow.BlackboardJobNode;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ProcessController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(ProcessController.class);
    @Resource(name="msroWfEngine")
    private transient Engine engine;
    @Resource
    private transient GraphProcessRegistry processRegistry;
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;
    @Resource(name="blackboardMessageFactory")
    private JaxbFactory<BlackboardMessage> messageFactory;
    @Resource(name="inspectorProcessGraphGenerator")
    private AbstractProcessGraphGenerator graphGenerator;
    @Resource(name="resourcelinkTool")
    private ResourceLinkTool linkTool;
    @Resource(name="containerBaseUrl")
    private String containerBaseUrl;

    @RequestMapping(value={"/inspector/msroAllProcesses.do"}, method={RequestMethod.GET})
    public void list(Model model) {
        log.info((Object)("listing: " + this.processRegistry.listIdentifiers()));
        List<ProcessListEntry> listItems = this.listItems();
        Collections.sort(listItems);
        model.addAttribute("processes", listItems);
    }

    @RequestMapping(value={"/inspector/msroAllProcesses.do"}, method={RequestMethod.POST})
    public String processGroupDelete(Model model, @RequestParam(value="status", required=true) String status) {
        final ProcessCompletionStatus completionStatus = ProcessCompletionStatus.valueOf((String)status);
        if (completionStatus.equals((Object)ProcessCompletionStatus.UNKNOWN)) {
            return "redirect:msroAllProcesses.do";
        }
        for (ProcessListEntry process : Iterables.filter(this.listItems(), (Predicate)new Predicate<ProcessListEntry>(){

            public boolean apply(ProcessListEntry arg) {
                return completionStatus.equals((Object)arg.getCompletionStatus());
            }
        })) {
            this.processRegistry.unregisterProcess(process.getPid());
        }
        return "redirect:msroAllProcesses.do";
    }

    private List<ProcessListEntry> listItems() {
        return MappedCollection.listMap(this.processRegistry.listIdentifiers(), (UnaryFunction)new UnaryFunction<ProcessListEntry, String>(){

            public ProcessListEntry evaluate(String pid) {
                return new ProcessListEntry(pid, ProcessController.this.processRegistry.findProcess(pid));
            }
        });
    }

    @RequestMapping(value={"/inspector/msroGraph.do"})
    public void graph(Model model, @RequestParam(value="pid", required=true) String pid) {
        GraphProcess process = this.processRegistry.findProcess(pid);
        model.addAttribute("pid", (Object)pid);
        model.addAttribute("graphName", (Object)process.getGraph().getName());
        model.addAttribute("map", (Object)this.graphGenerator.generateGraphImageMap(pid));
    }

    @RequestMapping(value={"/inspector/msroProcess.do"})
    public String process(Model model, @RequestParam(value="pid", required=true) String pid) {
        log.info((Object)("rendering one process " + pid));
        GraphProcess process = this.processRegistry.findProcess(pid);
        if (process == null) {
            return "inspector/noSuchMsroProcess";
        }
        if (process.getState() != ProcessState.Created) {
            model.addAttribute("map", (Object)this.graphGenerator.generateImageMap(pid));
            model.addAttribute("imageSize", (Object)this.graphGenerator.getImageSize(pid));
        }
        model.addAttribute("state", (Object)process.getState());
        model.addAttribute("isComplete", (Object)process.isComplete());
        model.addAttribute("pid", (Object)pid);
        HashMap<String, String> envParameters = new HashMap<String, String>();
        for (String key : process.getEnv().getAttributeNames()) {
            envParameters.put(key, process.getEnv().getAttribute(key));
        }
        model.addAttribute("tokenParameters", envParameters.entrySet());
        model.addAttribute("graphName", (Object)process.getGraph().getName());
        model.addAttribute("notificationHandlerName", (Object)process.getEnv().getAttribute("enableableName"));
        return "inspector/msroProcess";
    }

    @RequestMapping(value={"/inspector/msroProcessImage.do"})
    public void processImage(ServletResponse response, @RequestParam(value="pid", required=true) String pid, OutputStream out) throws IOException {
        response.setContentType("image/png");
        this.graphGenerator.writeImage(pid, "png", out);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/inspector/msroGraphImage.do"})
    public void graphImage(ServletResponse response, @RequestParam(value="pid", required=true) String pid, OutputStream out) throws IOException {
        response.setContentType("image/png");
        this.graphGenerator.writeGraphImage(pid, "png", out);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/inspector/msroProcessDelete.do"})
    public String processDelete(Model model, @RequestParam(value="pid", required=true) String pid) {
        log.info((Object)("deleting process " + pid));
        this.processRegistry.unregisterProcess(pid);
        return "redirect:msroAllProcesses.do";
    }

    @RequestMapping(value={"/inspector/msroProcessComplete.do"})
    public String processComplete(Model model, @RequestParam(value="pid", required=true) String pid, @RequestParam(value="as", required=true) String completeAsString) {
        CompleteAs completeAs = CompleteAs.valueOf(completeAsString);
        log.info((Object)("completing process " + pid + " as " + (Object)((Object)completeAs)));
        GraphProcess process = this.processRegistry.findProcess(pid);
        process.setState(ProcessState.Completed);
        if (completeAs == CompleteAs.Succeeded) {
            process.getEnv().setAttribute("isCompletedSuccessfully", (Object)true);
        }
        return "redirect:msroAllProcesses.do";
    }

    @RequestMapping(value={"/inspector/msroProcessNode.do"})
    public String processNode(Model model, @RequestParam(value="pid", required=true) String pid, @RequestParam(value="node", required=true) long nid) {
        model.addAttribute("pid", (Object)pid);
        model.addAttribute("nid", (Object)nid);
        GraphProcess process = this.processRegistry.findProcess(pid);
        if (process == null) {
            throw new IllegalArgumentException("process " + pid + " doesn't exist.");
        }
        Node node = this.findNode(process.getGraph(), nid);
        if (node == null) {
            throw new IllegalArgumentException("node " + nid + " doesn't exist");
        }
        NodeToken token = this.findNodeToken(process, node);
        if (token == null) {
            log.fatal((Object)"node not yet executed");
        }
        if (token != null) {
            model.addAttribute("arcs", (Object)node.getGraph().getOutputArcs(node));
            model.addAttribute("tid", (Object)token.getId());
            if (!token.getProcess().isArcTokenQueueEmpty()) {
                model.addAttribute("hasTokensInQueue", (Object)true);
            }
            EscapeHtml escape = new EscapeHtml();
            HashMap<String, String> tokenParameters = new HashMap<String, String>();
            for (String key : token.getFullEnv().getAttributeNames()) {
                tokenParameters.put(key, escape.evaluate(token.getFullEnv().getAttribute(key)));
            }
            HashMap<String, Object> transientTokenParameters = new HashMap<String, Object>();
            for (String key : token.getFullEnv().getTransientAttributeNames()) {
                transientTokenParameters.put(key, token.getFullEnv().getTransientAttribute(key));
            }
            model.addAttribute("tokenParameters", this.linkfyIds(tokenParameters).entrySet());
            model.addAttribute("transientTokenParameters", this.linkfyIds(transientTokenParameters).entrySet());
            log.debug((Object)("blackboard parameters: " + token.getEnv().getTransientAttribute("blackboardJob")));
            BlackboardJob job = (BlackboardJob)token.getEnv().getTransientAttribute("blackboardJob");
            if (node instanceof BlackboardJobNode && job != null) {
                model.addAttribute("notDone", (Object)(!job.isCompleted() ? 1 : 0));
                model.addAttribute("action", (Object)job.getAction());
                model.addAttribute("actionStatus", (Object)job.getActionStatus());
                model.addAttribute("date", (Object)job.getDate());
                model.addAttribute("id", (Object)job.getId());
                model.addAttribute("parameters", this.linkfyIds(job.getParameters()).entrySet());
                return "inspector/msroProcessNodeBlackboard";
            }
        }
        return "inspector/msroProcessNode";
    }

    private Map<String, String> linkfyIds(Map<String, ?> inputMap) {
        if (inputMap == null) {
            log.warn((Object)"empty job parameters!");
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, ?> e : inputMap.entrySet()) {
            map.put(e.getKey(), this.linkTool.linkfyToHtml("" + e.getValue()));
        }
        return map;
    }

    protected Node findNode(Graph graph, long nodeId) {
        for (Node node : graph.getNodes()) {
            if (node.getId() != nodeId) continue;
            return node;
        }
        return null;
    }

    protected NodeToken findNodeToken(GraphProcess process, Node node) {
        for (NodeToken token : process.getNodeTokens()) {
            if (token.getNode() != node) continue;
            return token;
        }
        return null;
    }

    protected NodeToken findNodeToken(GraphProcess process, long tid) {
        for (NodeToken token : process.getNodeTokens()) {
            if (token.getId() != tid) continue;
            return token;
        }
        return null;
    }

    @RequestMapping(value={"/inspector/msroProcessResendBB.do"})
    public String processNodeResendBB(@RequestParam(value="pid", required=true) String pid, @RequestParam(value="node", required=true) long nid) throws ISRegistryException, JAXBException {
        BlackboardJobImpl job;
        GraphProcess process = this.processRegistry.findProcess(pid);
        if (process == null) {
            throw new IllegalArgumentException("process " + pid + " doesn't exist");
        }
        Node node = this.findNode(process.getGraph(), nid);
        if (node == null) {
            throw new IllegalArgumentException("node " + nid + " doesn't exist");
        }
        NodeToken token = this.findNodeToken(process, node);
        if (token == null) {
            log.fatal((Object)"node not yet executed");
        }
        if ((job = (BlackboardJobImpl)token.getEnv().getTransientAttribute("blackboardJob")).isCompleted()) {
            throw new IllegalArgumentException("blackboard transaction already completed");
        }
        ((ISRegistryService)this.registryLocator.getService()).addBlackBoardMessage(job.getServiceId(), job.getId(), this.messageFactory.serialize((Object)job.getMessage()));
        return "redirect:msroProcess.do?pid=" + pid;
    }

    @RequestMapping(value={"/inspector/jumpToArc.do"})
    public String jumpToArc(@RequestParam(value="pid", required=true) String pid, @RequestParam(value="token", required=true) long tid, @RequestParam(value="arc", required=true) String arc) {
        GraphProcess process = this.processRegistry.findProcess(pid);
        NodeToken token = this.findNodeToken(process, tid);
        String arcName = arc;
        if ("".equals(arc)) {
            arcName = Arc.DEFAULT_ARC;
        }
        this.engine.complete(token, arcName);
        return "redirect:msroProcess.do?pid=" + pid;
    }

    @RequestMapping(value={"/inspector/executeProcessQueued.do"})
    public String executeProcessQueued(@RequestParam(value="pid", required=true) String pid) {
        GraphProcess process = this.processRegistry.findProcess(pid);
        this.engine.executeQueuedArcTokens(process);
        return "redirect:msroAllProcesses.do";
    }

    @RequestMapping(value={"/inspector/msroProcesses.do"})
    public void processes(Model model, @RequestParam(value="rid", required=true) String rid) {
        log.info((Object)("rendering process for resource " + rid));
        ArrayList<String> pids = new ArrayList<String>();
        for (GraphProcess process : this.processRegistry.findProcessesByResource(rid)) {
            log.info((Object)("rendering process " + this.processRegistry.getProcessIdentifier(process)));
            pids.add(this.processRegistry.getProcessIdentifier(process));
        }
        model.addAttribute("processes", pids);
    }

    @RequestMapping(value={"/inspector/msroRss.do"})
    public String rss(Model model, @RequestParam(value="status", required=false) String status, HttpServletResponse response) {
        response.setContentType("application/rss+xml");
        ArrayList items = Lists.newArrayList();
        ProcessCompletionStatus processStatus = null;
        if (status != null) {
            processStatus = ProcessCompletionStatus.valueOf((String)status);
        }
        for (String pid : this.processRegistry.listIdentifiers()) {
            ProcessListEntry pInfo = new ProcessListEntry(pid, this.processRegistry.findProcess(pid));
            if (processStatus != null) {
                if (!pInfo.getCompletionStatus().equals((Object)processStatus)) continue;
                items.add(new RssItem(pInfo));
                continue;
            }
            items.add(new RssItem(pInfo));
        }
        model.addAttribute("msroHome", (Object)(this.containerBaseUrl + "/inspector/msroAllProcesses.do"));
        model.addAttribute("pubDate", (Object)DateUtils.now_ISO8601());
        model.addAttribute("rssItems", (Object)items);
        return "inspector/msroRss";
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public JaxbFactory<BlackboardMessage> getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(JaxbFactory<BlackboardMessage> messageFactory) {
        this.messageFactory = messageFactory;
    }

    public AbstractProcessGraphGenerator getGraphGenerator() {
        return this.graphGenerator;
    }

    public void setGraphGenerator(AbstractProcessGraphGenerator graphGenerator) {
        this.graphGenerator = graphGenerator;
    }

    class RssItem {
        private String title;
        private String link;
        private String description;
        private String date;

        public RssItem(ProcessListEntry processListEntry) {
            this.title = processListEntry.getPid();
            this.link = ProcessController.this.containerBaseUrl + "/inspector/msroProcess.do?pid=" + processListEntry.getPid();
            this.description = processListEntry.getCompletionStatus().name();
            this.date = processListEntry.getLatestActivity();
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDate() {
            return this.date;
        }
    }

    public static enum CompleteAs {
        Succeeded,
        Failed;

    }
}

