/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.util.FontUtil;
import eu.dnetlib.enabling.inspector.msro.BaseJobIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class NodeIcon
extends BaseJobIcon {
    public NodeIcon(Node node, NodeToken token) {
        super(node, token);
    }

    @Override
    public void redrawImage(Graphics2D gfx) {
        int padding;
        super.redrawImage(gfx);
        gfx.fillOval(0, 0, 99, HEIGHT - 1);
        gfx.setColor(NodeDrawConfig.NODE_BORDER);
        int offset = 1;
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, this.getDashes(), 0.0f);
        gfx.setStroke(stroke);
        int width = 100 - ((offset << 1) + 1);
        int height = HEIGHT - ((offset << 1) + 1);
        gfx.drawOval(offset, offset, width, height);
        gfx.setColor(Color.white);
        int startX = padding = 2 + (offset += 3);
        int maxWidth = this.getIconWidth() - (padding << 1);
        FontUtil.setSizedFont((Graphics)gfx, (String)this.getLabel(), (float)10.0f, (int)maxWidth);
        int strWidth = (int)Math.ceil(gfx.getFontMetrics().getStringBounds(this.getLabel(), gfx).getWidth());
        int strHeight = gfx.getFontMetrics().getAscent();
        int left = startX + (maxWidth - strWidth >> 1);
        int top = this.getIconHeight() + strHeight >> 1;
        gfx.drawString(this.getLabel(), left, top);
        this.drawProgressBar(gfx);
    }
}

