/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Graph;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.load.SarasvatiLoadException;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.wf.ReindexAllWorkflowGenerator;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MSROController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(MSROController.class);
    @Resource(name="reindexAllWorkflowGraphGenerator")
    private transient ReindexAllWorkflowGenerator generator;
    @Resource
    private transient Engine engine;
    @Resource(name="deleteIndexGraph")
    private transient Graph deleteIndexGraph;
    @Resource(name="lookupLocator")
    private transient ServiceLocator<ISLookUpService> lookupLocator;

    @RequestMapping(value={"/inspector/msro.do"})
    public void msro(Model model) {
    }

    @RequestMapping(value={"/inspector/msroOverview.do"})
    public void overview(Model model) throws Exception {
        this.renderXQuery(model, "overview.xquery", "overview.xsl");
    }

    @RequestMapping(value={"/inspector/msroDuplicates.do"})
    public void duplicateIndices(Model model) throws Exception {
        this.renderXQuery(model, "duplicates.xquery", "duplicates.xsl");
    }

    @RequestMapping(value={"/inspector/msroDeleteIndex.do"})
    public String deleteIndex(@RequestParam(value="id", required=true) String ixId) {
        log.fatal((Object)("DELETING INDEX: " + ixId));
        GraphProcess process = this.engine.getFactory().newProcess(this.deleteIndexGraph);
        process.getEnv().setAttribute("id", ixId);
        this.engine.startProcess(process);
        return "redirect:msroAllProcesses.do";
    }

    protected void renderXQuery(Model model, String queryResource, String xsltResource) throws Exception {
        this.renderXQuery(model, ((Object)((Object)this)).getClass().getResourceAsStream(queryResource), ((Object)((Object)this)).getClass().getResourceAsStream(xsltResource));
    }

    public void renderXQuery(Model model, InputStream queryStream, InputStream xsltStream) throws Exception {
        StringWriter query = new StringWriter();
        StringWriter html = new StringWriter();
        IOUtils.copy((InputStream)queryStream, (Writer)query);
        String xml = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query.toString());
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xsltStream));
        transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(html));
        model.addAttribute("body", (Object)html);
    }

    @RequestMapping(value={"/inspector/msroReindexAllRepositories.do"})
    public String reindexAllRepositories() throws JAXBException, SarasvatiLoadException {
        this.engine.startProcess(this.generator.generateGraph());
        return "redirect:msroAllProcesses.do";
    }
}

