/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.ProcessToImageMapAdapter;
import com.googlecode.sarasvati.visual.process.VisualProcessNode;
import eu.dnetlib.enabling.inspector.msro.BlackboardJobIcon;
import eu.dnetlib.enabling.inspector.msro.JobIcon;
import eu.dnetlib.enabling.inspector.msro.NodeIcon;
import eu.dnetlib.enabling.inspector.msro.progress.NoSuchProgressProviderException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.workflow.AbstractJobNode;
import eu.dnetlib.workflow.BlackboardJobNode;
import java.text.SimpleDateFormat;
import javax.swing.Icon;

public class ImageMapHooks
extends ProcessToImageMapAdapter {
    private final transient String pid;

    public ImageMapHooks(String pid) {
        this.pid = pid;
    }

    public String hoverForNode(VisualProcessNode node) {
        String extra;
        String end;
        NodeToken token = node.getToken();
        if (token == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String start = sdf.format(token.getCreateDate());
        long delta = 0L;
        if (token.getCompleteDate() == null) {
            delta = DateUtils.now() - token.getCreateDate().getTime();
            end = "true".equals(token.getEnv().getAttribute("isBlackboard")) ? ("true".equals(token.getEnv().getAttribute("isOngoing")) ? "BB waiting for ongoing" : "BB ongoing") : "Not yet finished";
        } else {
            end = sdf.format(token.getCompleteDate());
            delta = token.getCompleteDate().getTime() - token.getCreateDate().getTime();
        }
        String elapsed = this.computeElapsed(delta);
        if (new Boolean(true) == token.getEnv().getAttribute("hasFailed", Boolean.class) && "true".equals(token.getEnv().getAttribute("hasFailed"))) {
            end = end + ". Failed: " + token.getEnv().getAttribute("errorMessage");
        }
        String prefix = "";
        String suffix = "";
        Node realNode = node.getNode();
        if (realNode instanceof AbstractJobNode && (extra = ((AbstractJobNode)realNode).getExtraDescription()) != null) {
            prefix = extra + " -- ";
        }
        if (realNode instanceof AbstractJobNode) {
            try {
                String pDesc = ((AbstractJobNode)realNode).getProgressDescription(token);
                if (pDesc != null) {
                    suffix = " -- " + pDesc;
                }
            }
            catch (NoSuchProgressProviderException e) {
                // empty catch block
            }
        }
        return prefix + "Started: " + start + " Finished: " + end + " Elapsed: " + elapsed + suffix;
    }

    private String computeElapsed(long delta) {
        long hours = delta / 3600000L;
        long minutes = delta % 3600000L / 60000L;
        long seconds = delta % 3600000L % 60000L / 1000L;
        String elapsed = "";
        if (hours < 10L) {
            elapsed = elapsed + "0";
        }
        elapsed = elapsed + hours + ":";
        if (minutes < 10L) {
            elapsed = elapsed + "0";
        }
        elapsed = elapsed + minutes + ":";
        if (seconds < 10L) {
            elapsed = elapsed + "0";
        }
        elapsed = elapsed + seconds;
        return elapsed;
    }

    public boolean drawArcLabels(Arc arc) {
        return false;
    }

    public Icon iconForNode(VisualProcessNode node) {
        if (node.getNode() instanceof BlackboardJobNode) {
            return new BlackboardJobIcon(node.getNode(), node.getToken());
        }
        if (node.getNode() instanceof AbstractJobNode) {
            return new JobIcon(node.getNode(), node.getToken());
        }
        return new NodeIcon(node.getNode(), node.getToken());
    }

    public String getPid() {
        return this.pid;
    }
}

