/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.googlecode.sarasvati.JoinType;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.icon.AbstractNodeIcon;
import eu.dnetlib.enabling.inspector.msro.progress.ProgressProvider;
import eu.dnetlib.workflow.AbstractJobNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseJobIcon
extends AbstractNodeIcon {
    private static final Log log = LogFactory.getLog(BaseJobIcon.class);
    protected static final int ROUND_CORNER = 10;
    protected static final int DASH_EMPTY = 4;
    protected static final int DASH_FULL = 8;
    protected static final int FONT_SIZE = 10;
    private Node node;
    private NodeToken token;
    private boolean join;
    private String label;
    private Color color;
    private Color progressBarColor = Color.decode("#205fbc");
    private Color inaccurateProgressBarColor = Color.decode("#111166");
    private Color progressBarBGColor = Color.LIGHT_GRAY;
    private float[] dashes;
    private boolean terminal;
    private ProgressProvider progressProvider;
    private boolean failed;

    public BaseJobIcon(Node node, NodeToken token) {
        this.node = node;
        this.token = token;
        if (node instanceof AbstractJobNode) {
            this.progressProvider = ((AbstractJobNode)node).getProgressProvider();
        }
        this.label = (String)node.getAdaptor(String.class);
        if (this.label == null) {
            this.label = node.getName();
        }
        this.join = node.getJoinType() == null ? false : node.getJoinType() != JoinType.OR;
        this.color = NodeDrawConfig.getColor((NodeToken)token);
        if (token != null && token.getEnv() != null && "true".equals(token.getEnv().getAttribute("hasFailed"))) {
            this.failed = true;
            this.color = Color.RED;
        }
        if (this.join) {
            this.dashes = new float[]{8.0f, 4.0f};
        }
        this.terminal = node.getGraph().getOutputArcs(node).size() == 0;
        this.redrawImage();
    }

    public void redrawImage(Graphics2D gfx) {
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setFont(Font.getFont("Monospaced"));
        if (this.isTerminal()) {
            gfx.setFont(gfx.getFont().deriveFont(1));
        }
        this.drawProgressBar(gfx);
        gfx.setColor(this.color);
    }

    protected void drawProgressBar(Graphics2D gfx) {
        try {
            if (this.progressProvider == null) {
                return;
            }
            if (this.token == null) {
                return;
            }
            if (this.token.isComplete() && !this.failed) {
                return;
            }
            int total = this.progressProvider.getTotalValue(this.node, this.token);
            int current = this.progressProvider.getCurrentValue(this.node, this.token);
            if (current > total) {
                return;
            }
            int x = 6;
            int y = this.getIconHeight() - 6;
            int widthTot = this.getIconWidth() - x - x;
            int height = 2;
            gfx.setColor(this.progressBarBGColor);
            gfx.fillRect(x, y, widthTot, height);
            if (this.progressProvider.isInaccurate()) {
                gfx.setColor(this.inaccurateProgressBarColor);
                for (int i = (int)Math.round(Math.random() * 4.0); i < widthTot - 4; i += 8) {
                    gfx.fillRect(x + i, y, 4, height);
                }
            } else {
                gfx.setColor(this.progressBarColor);
                int widthCurr = 0;
                if (total > 0) {
                    widthCurr = Math.round(widthTot * current / total);
                }
                gfx.fillRect(x, y, widthCurr, height);
            }
            gfx.setColor(this.color);
        }
        catch (Throwable e) {
            log.warn((Object)"got exception drawing progress bar", e);
        }
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float[] getDashes() {
        return this.dashes;
    }

    public void setDashes(float[] dashes) {
        this.dashes = dashes;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodeToken getToken() {
        return this.token;
    }

    public void setToken(NodeToken token) {
        this.token = token;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public Color getProgressBarColor() {
        return this.progressBarColor;
    }

    public void setProgressBarColor(Color progressBarColor) {
        this.progressBarColor = progressBarColor;
    }

    public Color getProgressBarBGColor() {
        return this.progressBarBGColor;
    }

    public void setProgressBarBGColor(Color progressBarBGColor) {
        this.progressBarBGColor = progressBarBGColor;
    }

    public Color getInaccurateProgressBarColor() {
        return this.inaccurateProgressBarColor;
    }

    public void setInaccurateProgressBarColor(Color inaccurateProgressBarColor) {
        this.inaccurateProgressBarColor = inaccurateProgressBarColor;
    }
}

