/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector.msro;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.visual.GraphImageMapCreator;
import com.googlecode.sarasvati.visual.GraphToImageMap;
import com.googlecode.sarasvati.visual.GraphToImageMapAdapter;
import com.googlecode.sarasvati.visual.ProcessImageMapCreator;
import com.googlecode.sarasvati.visual.ProcessToImageMap;
import eu.dnetlib.workflow.GraphProcessRegistry;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;

public abstract class AbstractProcessGraphGenerator {
    @Resource
    private transient GraphProcessRegistry processRegistry;

    public void writeImage(String pid, String format, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)this.getProcessImage(pid), "png", out);
    }

    public ImageSize getImageSize(String pid) {
        BufferedImage image = this.getProcessImage(pid);
        return new ImageSize(image.getWidth(), image.getHeight());
    }

    public void writeGraphImage(String pid, String format, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)this.getGraphImage(pid), "png", out);
    }

    public ImageSize getGraphImageSize(String pid) {
        BufferedImage image = this.getGraphImage(pid);
        return new ImageSize(image.getWidth(), image.getHeight());
    }

    public String generateImageMap(String pid) {
        return this.getProcessImageCreator(pid).getMapContents();
    }

    public String generateGraphImageMap(String pid) {
        return this.getGraphImageCreator(pid).getMapContents();
    }

    protected GraphImageMapCreator getGraphImageCreator(String pid) {
        GraphProcess process = this.processRegistry.findProcess(pid);
        GraphToImageMap helper = this.graphImageHooks(pid);
        GraphImageMapCreator imageMapCreator = new GraphImageMapCreator(process.getGraph(), helper);
        return imageMapCreator;
    }

    protected BufferedImage getGraphImage(String pid) {
        return this.getGraphImageCreator(pid).getImage();
    }

    protected ProcessImageMapCreator getProcessImageCreator(String pid) {
        ProcessToImageMap helper = this.imageHooks(pid);
        GraphProcess process = this.processRegistry.findProcess(pid);
        ProcessImageMapCreator imageMapCreator = new ProcessImageMapCreator(process, helper);
        return imageMapCreator;
    }

    protected BufferedImage getProcessImage(String pid) {
        return this.getProcessImageCreator(pid).getImage();
    }

    protected abstract ProcessToImageMap imageHooks(String var1);

    protected GraphToImageMap graphImageHooks(String pid) {
        return new GraphToImageMapAdapter();
    }

    public static class ImageSize {
        private int width;
        private int height;

        public ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

