/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information;

import eu.dnetlib.data.information.DataSource;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.EPRDataSource;
import java.net.URI;
import java.net.URISyntaxException;

public class EPRDataSourceResolverImpl
implements DataSourceResolver {
    private static final String URI_AUTHORITY = "EPR";

    public DataSource resolve(String descriptor) {
        try {
            URI uri = new URI(descriptor);
            if (!uri.getAuthority().equals(URI_AUTHORITY)) {
                throw new IllegalStateException("unexpected uri descriptor " + descriptor + ". This sink resolver is specific for " + URI_AUTHORITY);
            }
            return new EPRDataSource(uri.getPath().substring(1));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

