/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.store.sync;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.sync.OAIStoreContentSynchronizerFactory;
import eu.dnetlib.enabling.tools.AbstractSchedulable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SchedulableContentSynchronizer
extends AbstractSchedulable {
    private static final Log log = LogFactory.getLog(SchedulableContentSynchronizer.class);
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;
    private OAIStoreContentSynchronizerFactory contentSyncFactory;
    private int maxInitThreads = 2;

    protected void doExecute() {
        log.info((Object)("Synchronizing OAI stores with content using synchronizer from factory: " + this.contentSyncFactory.getClass().getCanonicalName()));
        new Thread(){

            @Override
            public void run() {
                SchedulableContentSynchronizer.this.checkStores();
            }
        }.start();
        log.info((Object)"OAI Publisher configuration updated.");
    }

    protected void checkStores() {
        ExecutorService executor = Executors.newFixedThreadPool(this.maxInitThreads);
        List<MDFInfo> metadataFormats = this.configuration.getMetadataFormatInfo();
        ArrayList futures = Lists.newArrayList();
        for (MDFInfo mdf : metadataFormats) {
            futures.add(executor.submit(this.contentSyncFactory.create(mdf)));
        }
        executor.shutdown();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
    }

    public int getMaxInitThreads() {
        return this.maxInitThreads;
    }

    public void setMaxInitThreads(int maxInitThreads) {
        this.maxInitThreads = maxInitThreads;
    }

    public OAIConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationReader configuration) {
        this.configuration = configuration;
    }

    public OAIStoreContentSynchronizerFactory getContentSyncFactory() {
        return this.contentSyncFactory;
    }

    @Required
    public void setContentSyncFactory(OAIStoreContentSynchronizerFactory contentSyncFactory) {
        this.contentSyncFactory = contentSyncFactory;
    }
}

