/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import com.google.common.collect.Lists;
import com.sun.xml.messaging.saaj.util.Base64;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.ISLookUpClient;
import eu.dnetlib.data.information.oai.publisher.core.AbstractOAICore;
import eu.dnetlib.data.information.oai.publisher.core.ResumptionToken;
import eu.dnetlib.data.information.oai.publisher.core.ResumptionTokenImpl;
import eu.dnetlib.data.information.oai.publisher.info.ListDocumentsInfo;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.ConfigurationSetCollection;
import eu.dnetlib.data.information.oai.publisher.store.Cursor;
import eu.dnetlib.data.information.oai.publisher.store.PublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.PublisherStoreDAO;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class DNetOAICore
extends AbstractOAICore {
    private static final Log log = LogFactory.getLog(DNetOAICore.class);
    public static final String REPO_BASE64_SUFFIX = new String(Base64.encode((byte[])"RepositoryServiceResources/RepositoryServiceResourceType".getBytes()));
    @Resource
    private ISLookUpClient lookupClient;
    @Resource
    private ConfigurationSetCollection configurationSetCollection;
    @Resource
    private PublisherStoreDAO<PublisherStore<Cursor>, Cursor> publisherStoreDAO;
    private String defaultDate = "2008-01-01T12:00:00Z";
    private int pageSize = 100;

    protected RecordInfo getRecordById(MDFInfo mdf, String setSpec, String id) throws OaiPublisherException {
        String recordID = StringUtils.isBlank((String)setSpec) ? id : setSpec + "_" + REPO_BASE64_SUFFIX + "::" + id;
        PublisherStore store = this.publisherStoreDAO.getStoreFor(mdf.getPrefix());
        if (store == null) {
            throw new OaiPublisherRuntimeException("Missing store for metadata prefix " + mdf.getPrefix() + ". Please check OAI publisher configuration.");
        }
        RecordInfo record = null;
        if (StringUtils.isBlank((String)mdf.getTransformationRuleID())) {
            record = store.getRecord(recordID);
        } else {
            UnaryFunction<String, String> function = this.lookupClient.getUnaryFunctionFromTDSRule(mdf.getTransformationRuleID());
            record = store.getRecord(recordID, function);
        }
        if (record != null) {
            record.setPrefix(mdf.getPrefix());
        }
        return record;
    }

    public List<SetInfo> listSets() throws OaiPublisherException {
        try {
            ArrayList<SetInfo> sets = new ArrayList<SetInfo>();
            sets.addAll(this.lookupClient.listRepositories());
            sets.addAll(this.configurationSetCollection.getAllSets());
            return sets;
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherException("Error executing listSets", (Throwable)e);
        }
    }

    public List<MDFInfo> listMetadataFormats() throws OaiPublisherException {
        try {
            return this.lookupClient.listMetadataFormats(true);
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherException("Error invoking lookup", (Throwable)e);
        }
        catch (DocumentException e) {
            throw new OaiPublisherException("Error in metadata formats xml profile", (Throwable)e);
        }
    }

    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String set, String metadataPrefix, String from, String until) throws OaiPublisherException {
        try {
            MDFInfo mdf = this.obtainMDFInfo(metadataPrefix);
            String query = this.generateQuery(mdf, set, from, until);
            Cursor results = this.getCursor(query, onlyIdentifiers, mdf);
            log.debug((Object)("Total number of records: " + results.count()));
            ListDocumentsInfo res = this.prepareListDocumentsInfo(results, mdf, query, set, 0, results.count());
            log.debug((Object)("Delivering " + res.getDocs().size() + " in a page"));
            return res;
        }
        catch (Exception e) {
            throw new OaiPublisherException((Throwable)e);
        }
    }

    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ResumptionTokenImpl resToken = new ResumptionTokenImpl();
        resToken.deserialize(resumptionToken);
        log.info((Object)resToken.toString());
        MDFInfo mdf = this.obtainMDFInfo(resToken.getMetadataPrefix());
        String lastID = resToken.getLastObjIdentifier();
        String query = resToken.getQuery();
        String newQuery = query + " AND _id > \"" + lastID + "\"";
        log.debug((Object)("NEW QUERY BECAUSE of resumptionToken: " + newQuery));
        Cursor results = this.getCursor(newQuery, onlyIdentifiers, mdf);
        int oldCount = resToken.getnMaxElements();
        int newCount = results.count() + resToken.getnRead();
        if (oldCount != newCount) {
            throw new OaiPublisherException("badResumptionToken");
        }
        ListDocumentsInfo res = this.prepareListDocumentsInfo(results, mdf, query, resToken.getRequestedSet(), resToken.getnRead(), resToken.getnMaxElements());
        res.setCursor(resToken.getnRead());
        return res;
    }

    protected MDFInfo obtainMDFInfo(String metadataPrefix) throws OaiPublisherException {
        MDFInfo mdf = this.configurationSetCollection.getConfiguration().getMetadataFormatInfo(metadataPrefix);
        if (mdf == null) {
            throw new OaiPublisherException("Invalid metadataPrefix " + metadataPrefix);
        }
        return mdf;
    }

    protected ListDocumentsInfo prepareListDocumentsInfo(Cursor results, MDFInfo mdf, String query, String requestedSet, int read, int totalNumber) throws OaiPublisherException {
        ListDocumentsInfo documentList = new ListDocumentsInfo();
        documentList.setnMaxElements(totalNumber);
        documentList.setMetadataPrefix(mdf.getPrefix());
        documentList.setCursor(0);
        List<RecordInfo> theRecords = this.generateOAIRecords(mdf, requestedSet, results);
        if (documentList.getnMaxElements() <= 0) {
            throw new OaiPublisherException("noRecordsMatch");
        }
        documentList.setDocs(theRecords);
        if (theRecords == null || theRecords.isEmpty()) {
            throw new OaiPublisherException("noRecordsMatch: 'documents' is null or empty");
        }
        if (documentList.getnMaxElements() > read + theRecords.size()) {
            String lastID = theRecords.get(theRecords.size() - 1).getInternalId();
            ResumptionTokenImpl nextToken = new ResumptionTokenImpl();
            nextToken.setLastObjIdentifier(lastID);
            nextToken.setMetadataPrefix(mdf.getPrefix());
            nextToken.setnMaxElements(totalNumber);
            nextToken.setnRead(read + theRecords.size());
            nextToken.setQuery(query);
            nextToken.setRequestedSet(requestedSet);
            documentList.setResumptionToken((ResumptionToken)nextToken);
        }
        return documentList;
    }

    protected Cursor getCursor(String query, boolean onlyIdentifiers, MDFInfo mdfInfo) {
        PublisherStore store = this.publisherStoreDAO.getStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(), mdfInfo.getSourceFormatLayout());
        if (store == null) {
            throw new OaiPublisherRuntimeException("Missing store for metadata prefix " + mdfInfo.getPrefix() + ". Please check OAI publisher configuration.");
        }
        Cursor results = null;
        if (StringUtils.isBlank((String)mdfInfo.getTransformationRuleID())) {
            results = store.getRecords(query, !onlyIdentifiers);
        } else {
            UnaryFunction<String, String> function = this.lookupClient.getUnaryFunctionFromTDSRule(mdfInfo.getTransformationRuleID());
            results = store.getRecords(query, function, !onlyIdentifiers);
        }
        return results;
    }

    protected List<RecordInfo> generateOAIRecords(MDFInfo mdf, String requestedSet, Cursor cursor) {
        ArrayList documents = Lists.newArrayList();
        Iterator cursorIterator = cursor.iterator();
        for (int i = 0; cursorIterator.hasNext() && i < this.pageSize; ++i) {
            RecordInfo current = (RecordInfo)cursorIterator.next();
            current.addSetspec(requestedSet);
            current.setPrefix(mdf.getPrefix());
            documents.add(current);
        }
        return documents;
    }

    protected String generateQuery(MDFInfo mdf, String set, String from, String until) {
        String datestampIndexName = "datestamp";
        String query = mdf.getBaseQuery();
        if (set != null) {
            if (query.length() > 0) {
                query = query + " AND ";
            }
            query = query + this.obtainQuerySet(set);
        }
        if (from != null && until != null) {
            if (query.length() > 0) {
                query = query + " AND ";
            }
            query = query + datestampIndexName + " >= " + from + " AND " + datestampIndexName + " <= " + until;
        } else if (from != null) {
            if (query.length() > 0) {
                query = query + " AND ";
            }
            query = query + datestampIndexName + " >= " + from;
        } else if (until != null) {
            if (query.length() > 0) {
                query = query + " AND ";
            }
            query = query + datestampIndexName + " <= " + until;
        }
        log.info((Object)("QUERY GENERATED: \n" + query));
        return query;
    }

    private String obtainQuerySet(String set) {
        String query = "(set = \"" + set + "_" + REPO_BASE64_SUFFIX + "\")";
        if (this.configurationSetCollection.containSet(set)) {
            query = this.configurationSetCollection.getSetQuery(set);
        }
        return query;
    }

    public void setLookupClient(ISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }

    public String getDefaultDate() {
        return this.defaultDate;
    }

    public void setDefaultDate(String defaultDate) {
        this.defaultDate = defaultDate;
    }

    public ConfigurationSetCollection getConfigurationSetCollection() {
        return this.configurationSetCollection;
    }

    public void setConfigurationSetCollection(ConfigurationSetCollection configurationSetCollection) {
        this.configurationSetCollection = configurationSetCollection;
    }

    public PublisherStoreDAO<PublisherStore<Cursor>, Cursor> getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(PublisherStoreDAO<PublisherStore<Cursor>, Cursor> publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

