/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf.sync;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.information.oai.publisher.conf.sync.OAIConfigurationUpdaterFactory;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIConfigurationNotificationHandler
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(OAIConfigurationNotificationHandler.class);
    @Resource
    private OAIConfigurationStringReader configurationReader;
    private int maxThreads = 2;
    @Resource
    private OAIConfigurationUpdaterFactory initializerFactory;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        if (!topic.startsWith(this.getTopicPrefix()) || !this.isEnabled()) {
            return;
        }
        log.info((Object)"Starting OAI configuration update...");
        this.configurationReader.readConfiguration(profile);
        List<MDFInfo> metadataFormats = this.configurationReader.getMetadataFormatInfo();
        ExecutorService executor = Executors.newFixedThreadPool(this.maxThreads);
        ArrayList futures = Lists.newArrayList();
        for (MDFInfo mdf : metadataFormats) {
            futures.add(executor.submit(this.initializerFactory.create(mdf)));
        }
        executor.shutdown();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new OaiPublisherRuntimeException((Throwable)e);
            }
        }
        log.info((Object)"OAI configuration applied to the oai stores...");
    }

    public OAIConfigurationStringReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationStringReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public OAIConfigurationUpdaterFactory getInitializerFactory() {
        return this.initializerFactory;
    }

    public void setInitializerFactory(OAIConfigurationUpdaterFactory initializerFactory) {
        this.initializerFactory = initializerFactory;
    }
}

