/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.IdentityFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class ISLookUpClient {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configuration;
    private static final Log log = LogFactory.getLog(ISLookUpClient.class);

    public List<MDFInfo> listMetadataFormats(boolean onlyEnabled) throws ISLookUpException, DocumentException, OaiPublisherException {
        return Lists.newArrayList(this.configuration.getMetadataFormatInfo(onlyEnabled));
    }

    public List<SetInfo> listRepositories() throws ISLookUpException {
        String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//RESOURCE_IDENTIFIER/@value/string(),'|-$-|',$x//OFFICIAL_NAME/string(),'|-$-|',$x//ENGLISH_NAME/string())";
        ArrayList<SetInfo> response = new ArrayList<SetInfo>();
        for (String item : ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//RESOURCE_IDENTIFIER/@value/string(),'|-$-|',$x//OFFICIAL_NAME/string(),'|-$-|',$x//ENGLISH_NAME/string())")) {
            String repoId;
            String[] repoInfo = item.split("\\|-\\$-\\|");
            if (repoInfo.length != 3) {
                log.fatal((Object)"There are missing information in Repository Profile while getting the list of sets ");
            }
            if (StringUtils.isBlank((String)(repoId = repoInfo[0]))) {
                log.fatal((Object)"Missing repository id: can't generate set");
                continue;
            }
            String repoOfficialName = repoInfo[1];
            String repoEnglishName = repoInfo[2];
            boolean hasName = true;
            if (StringUtils.isBlank((String)repoOfficialName) && StringUtils.isBlank((String)repoEnglishName)) {
                hasName = false;
                log.fatal((Object)("Missing official or english name in repository profile " + repoId));
            }
            SetInfo set = new SetInfo();
            set.setSetSpec(repoId.substring(0, repoId.indexOf("_")));
            if (hasName) {
                String repoName = StringUtils.join((Collection)Lists.newArrayList((Object[])new String[]{repoOfficialName, repoEnglishName}), (String)" - ");
                set.setSetName(repoName);
                set.setSetDescription("This set contains metadata originally harvested from the repository " + repoName);
            }
            response.add(set);
        }
        return response;
    }

    public UnaryFunction<String, String> getUnaryFunctionFromTDSRule(String tdsRuleId) {
        String queryCodeRule = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsRuleId + "']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
        String xsltCode = null;
        try {
            xsltCode = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(queryCodeRule);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.fatal((Object)("Unexisting TDSRule profile with identifier " + tdsRuleId));
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        if (StringUtils.isBlank((String)xsltCode)) {
            log.warn((Object)("Unexpected blank stylesheet in TDSRule profile with id: " + tdsRuleId + ". Returning identity function."));
            return new IdentityFunction();
        }
        return new ApplyXslt(xsltCode);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public OAIConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationReader configuration) {
        this.configuration = configuration;
    }
}

