/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.pep;

import eu.dnetlib.espas.pep.PEPResponse;
import eu.dnetlib.espas.pep.PEPResponseMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceException;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceStub;

public class AuthenticationPEP {
    private static final Logger _logger = Logger.getLogger(AuthenticationPEP.class);
    private EntitlementServiceStub entServiceStub;
    private Resource trustStore = null;
    private String trustStorePassword = null;
    private String serverUsername = null;
    private String serverPassword = null;
    private String serverUrl = null;
    private long connectionTimeout = 0L;

    public void initEntitlementService() throws Exception {
        File tempFile = File.createTempFile("trs", null);
        FileOutputStream fos = new FileOutputStream(tempFile);
        tempFile.deleteOnExit();
        IOUtils.copy((InputStream)this.trustStore.getInputStream(), (OutputStream)fos);
        fos.close();
        System.setProperty("javax.net.ssl.trustStore", tempFile.getCanonicalPath());
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        ConfigurationContext confContx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        HttpTransportProperties.Authenticator httpAuthenticator = new HttpTransportProperties.Authenticator();
        httpAuthenticator.setUsername(this.serverUsername);
        httpAuthenticator.setPassword(this.serverPassword);
        httpAuthenticator.setPreemptiveAuthentication(true);
        this.entServiceStub = new EntitlementServiceStub(confContx, this.serverUrl);
        ServiceClient srv2client = this.entServiceStub._getServiceClient();
        Options _options = srv2client.getOptions();
        _options.setManageSession(true);
        _options.setProperty("Cookie", null);
        _options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)httpAuthenticator);
        _options.setManageSession(true);
        _options.setTimeOutInMilliSeconds(this.connectionTimeout);
        srv2client.setOptions(_options);
        _logger.info((Object)"Entitlement service initialized succesfully");
    }

    public synchronized PEPResponseMap isPermitedRequest(Collection<String> requestedObs, String userId, String actionName, String[] environment) throws RemoteException {
        _logger.info((Object)("Evaluating request for [" + requestedObs.size() + ", " + userId + ", " + actionName + "]"));
        PEPResponseMap responseMap = new PEPResponseMap();
        if (this.entServiceStub != null) {
            for (String requestedResource : requestedObs) {
                try {
                    String getDecisionOutcome = this.entServiceStub.getDecisionByAttributes(userId, requestedResource, actionName, environment);
                    _logger.trace((Object)("Evaluation of [" + requestedObs.size() + ", " + userId + ", " + actionName + "] returned :" + getDecisionOutcome));
                    String[] pepRespopnse = this.getPDPResults(getDecisionOutcome);
                    PEPResponse pepResponse = new PEPResponse(requestedResource, pepRespopnse[1], pepRespopnse[0].contains("Permit"));
                    responseMap.addResponse(requestedResource, pepResponse);
                }
                catch (XMLStreamException ex) {
                    _logger.error(null, (Throwable)ex);
                }
                catch (EntitlementServiceException ex) {
                    _logger.error(null, (Throwable)ex);
                }
                catch (Exception ex) {
                    _logger.error(null, (Throwable)ex);
                }
            }
        }
        return responseMap;
    }

    public synchronized boolean isPermitedRequest(String requestedOb, String userId, String actionName, String[] environment) throws RemoteException, EntitlementServiceException, Exception {
        _logger.info((Object)("Evaluating request for [" + requestedOb + ", " + userId + ", " + actionName + "]"));
        if (this.entServiceStub != null) {
            String outcome = this.entServiceStub.getDecisionByAttributes(userId, requestedOb, actionName, environment);
            _logger.info((Object)("Evaluation of [" + requestedOb + ", " + userId + ", " + actionName + "] returned :" + outcome));
            return outcome.contains("Permit");
        }
        return false;
    }

    public synchronized boolean isPermitedRequest(String request) throws RemoteException, EntitlementServiceException, Exception {
        _logger.info((Object)("Evaluating request " + request));
        if (this.entServiceStub != null) {
            String outcome = this.entServiceStub.getDecision(request);
            _logger.info((Object)("Evaluation of [" + request + "] returned :" + outcome));
            return outcome.contains("Permit");
        }
        return false;
    }

    public Resource getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(Resource trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getServerUsername() {
        return this.serverUsername;
    }

    public void setServerUsername(String serverUsername) {
        this.serverUsername = serverUsername;
    }

    public String getServerPassword() {
        return this.serverPassword;
    }

    public void setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected String[] getPDPResults(String response) throws XMLStreamException {
        String[] resultMsg = new String[2];
        OMElement omElement = AXIOMUtil.stringToOM((String)response);
        if (omElement != null && omElement.getChildElements().hasNext()) {
            OMElement attributeAssignOM;
            OMElement resultOM = omElement.getFirstChildWithName(new QName("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Result"));
            OMElement decisionOM = resultOM.getFirstChildWithName(new QName("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Decision"));
            resultMsg[0] = decisionOM != null ? ((OMText)decisionOM.getFirstOMChild()).getText() : "";
            OMElement advice = resultOM.getFirstChildWithName(new QName("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "AssociatedAdvice"));
            resultMsg[1] = advice != null ? ((attributeAssignOM = advice.getFirstElement().getFirstChildWithName(new QName("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "AttributeAssignment"))) != null ? ((OMText)attributeAssignOM.getFirstOMChild()).getText() : "") : "";
        }
        return resultMsg;
    }
}

