--CREATE TYPE status AS ENUM ('ACTIVE', 'INACTIVE');

CREATE TABLE Scenarios (
    Name varchar(255) primary key,
    Description text,
    Status varchar(25) not null default 'active',
    LastModified timestamp
);

CREATE TABLE LogStash (
    Id serial primary key,
    TimeMarker timestamp default now(),
    MonitoringScenario varchar(255) not null references Scenarios(name),
    SensorType varchar(255) not null, 
    SensorId varchar(255) not null,
    Metric varchar(255) not null,
    Labels json,
    Log float not null
);

CREATE TABLE Controls (
    Id serial primary key,
    Name varchar(255) not null,
    MonitoringScenario varchar(255) not null references Scenarios(name),
    Selectors json,
    AnalyzerClass varchar(255) not null,
    Status varchar(25) not null default 'active',
    LastModified timestamp default now()
);

CREATE TABLE Configurations (
    Id serial primary key,
    Name varchar(255),
    Params json,
    LastModified timestamp default now(),
    Status varchar(25) not null default 'active'
);