/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.metrics.rest;

import eu.dnetlib.monitoring.controls.Control;
import eu.dnetlib.monitoring.controls.Selector;
import eu.dnetlib.monitoring.controls.analyzers.AnalyzerFactory;
import eu.dnetlib.monitoring.server.dao.GenericControlDAO;
import eu.dnetlib.monitoring.server.dao.GenericStashDAO;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/reports"})
public class ReportController {
    private static final Logger log = Logger.getLogger(ReportController.class);
    @Autowired
    @Qualifier(value="chosenDao")
    private GenericStashDAO observationDao;
    @Autowired
    private GenericControlDAO controlDao;

    @RequestMapping(value={"/{metric}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Control> getControlsByMetric(@PathVariable String scenario, @PathVariable String metric) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        List controls = this.controlDao.listActiveControls(scenario, metric);
        for (Control ctrl : controls) {
            ArrayList observations = new ArrayList();
            for (Selector s : ctrl.getSelectors()) {
                observations.addAll(this.observationDao.findKLastObservations(ctrl.getMonitoringScenario(), s.getMetric(), s.getLabelName(), s.getLabelValue(), s.getSamples().intValue()));
            }
            ctrl.setResult(AnalyzerFactory.createAnalyzer((String)ctrl.getAnalyzerClass()).analyze(observations));
        }
        return controls;
    }
}

