/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.controls.analyzers.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import eu.dnetlib.monitoring.controls.analyzers.Analyzer;
import eu.dnetlib.monitoring.controls.analyzers.impl.IsMonotonicDecreasing;
import eu.dnetlib.monitoring.controls.analyzers.impl.IsMonotonicIncreasing;
import eu.dnetlib.monitoring.controls.analyzers.impl.SameTrend;
import eu.dnetlib.monitoring.model.Observation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SameTrend
extends Analyzer {
    private IsMonotonicIncreasing helperAnalyzerIncreasing = new IsMonotonicIncreasing();
    private IsMonotonicDecreasing helperAnalyzerDecreasing = new IsMonotonicDecreasing();

    public boolean analyze(List<Observation> observations) {
        ArrayListMultimap observationsBySelector = ArrayListMultimap.create();
        for (Observation o : observations) {
            observationsBySelector.put((Object)Joiner.on((String)"-").join((Object)o.getMetric(), (Object)this.getLabelValue(o), new Object[0]), (Object)o);
        }
        Trend expectedTrend = Trend.UNDEFINED;
        block6: for (Collection obs : observationsBySelector.asMap().values()) {
            ArrayList obsList = Lists.newArrayList((Iterable)obs);
            switch (1.$SwitchMap$eu$dnetlib$monitoring$controls$analyzers$impl$SameTrend$Trend[expectedTrend.ordinal()]) {
                case 1: {
                    if (this.helperAnalyzerIncreasing.analyze((List)obsList)) continue block6;
                    return false;
                }
                case 2: {
                    if (this.helperAnalyzerDecreasing.analyze((List)obsList)) continue block6;
                    return false;
                }
                case 3: {
                    if (!this.helperAnalyzerIncreasing.analyze((List)obsList) && !this.helperAnalyzerDecreasing.analyze((List)obsList)) continue block6;
                    return false;
                }
            }
            if (this.helperAnalyzerIncreasing.analyze((List)obsList)) {
                expectedTrend = Trend.INCR;
                continue;
            }
            if (this.helperAnalyzerDecreasing.analyze((List)obsList)) {
                expectedTrend = Trend.DECR;
                continue;
            }
            expectedTrend = Trend.UNKNOWN;
        }
        return true;
    }

    public String getName() {
        return "Have same trend";
    }

    public String getDescription() {
        return "Works with 2+ selectors. Checks if the two selectors have the same trend (increasing or decreasing).";
    }

    private String getLabelValue(Observation o) {
        Iterator values = o.getLabels().values().iterator();
        if (values.hasNext()) {
            return (String)values.next();
        }
        return null;
    }
}

