/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.configurations.rest;

import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/configurations"})
public class ConfigurationController {
    private static final Logger log = Logger.getLogger(ConfigurationController.class);
    @Autowired
    private GenericConfigurationDAO confDao;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SensorConfiguration> ListConfigurationsByScenario(@PathVariable String scenario) {
        log.info((Object)("Listing available configurations for scenario " + scenario));
        List listConfigurations = this.confDao.listConfigurations(scenario);
        return listConfigurations;
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public SensorConfiguration getConfigurationByName(@PathVariable String scenario, @PathVariable String name) {
        log.info((Object)("Returning configuration " + name + " for scenario " + scenario));
        SensorConfiguration configuration = this.confDao.getConfiguration(scenario, name);
        return configuration;
    }
}

