/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.monitoring.metrics.rest;

import eu.dnetlib.monitoring.model.Observation;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;
import eu.dnetlib.monitoring.server.dao.GenericStashDAO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scenarios/{scenario}/metrics"})
public class MetricsController {
    private static final Logger log = Logger.getLogger(MetricsController.class);
    @Autowired
    @Qualifier(value="chosenDao")
    private GenericStashDAO observationDao;
    @Autowired
    private GenericConfigurationDAO confDao;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<String> getAllMetrics(@PathVariable String scenario) {
        List metrics = this.confDao.listMetrics(scenario);
        return metrics;
    }

    @RequestMapping(value={"/{metric}/labels"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> listLabelNameByMetric(@PathVariable String scenario, @PathVariable String metric) {
        log.info((Object)String.format("List labels of (%s) in scenario (%s)", metric, scenario));
        return this.confDao.listLabelNames(scenario, metric);
    }

    @RequestMapping(value={"/{metric}/labels/{label}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> listLabelValuesByMetric(@PathVariable String scenario, @PathVariable String metric, @PathVariable String label) {
        log.info((Object)String.format("List values of (%s) (%s) in scenario (%s)", metric, label, scenario));
        return this.confDao.listLabelValues(scenario, metric, label);
    }

    @RequestMapping(value={"/{metric}/observations"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getObservationsByMetricInC3ReadyFormat(@PathVariable String scenario, @PathVariable String metric, @RequestParam(required=false) String label) {
        List observations = this.getObservationsByMetric(scenario, metric, label);
        LinkedHashMap outerMap = new LinkedHashMap();
        HashSet<String> foundLabelValues = new HashSet<String>();
        for (Observation o : observations) {
            Map<String, Double> innerMap;
            Long timestamp = o.getTimestamp();
            if (!outerMap.containsKey(timestamp)) {
                innerMap = new HashMap<String, Long>();
                innerMap.put("timestamp", (Double)((Object)timestamp));
            } else {
                innerMap = (Map)outerMap.get(timestamp);
            }
            String labelValue = (String)o.getLabels().get(label);
            if (labelValue != null) {
                foundLabelValues.add(labelValue);
                innerMap.put(labelValue, o.getLog());
                outerMap.put(timestamp, innerMap);
                continue;
            }
            foundLabelValues.add("undefined");
            innerMap.put("undefined", o.getLog());
            outerMap.put(timestamp, innerMap);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("observations", outerMap.values());
        retMap.put("labelValues", foundLabelValues);
        return retMap;
    }

    public List<Observation> getObservationsByMetric(String scenario, String metric, String label) {
        if (label != null) {
            log.info((Object)String.format("Retrieve observations for metric (%s) (%s) in scenario (%s)", metric, label, scenario));
            return this.observationDao.findObservations(scenario, metric, label);
        }
        log.info((Object)String.format("Retrieve observations for metric (%s) in scenario (%s)", metric, scenario));
        return this.observationDao.findObservations(scenario, metric);
    }
}

