CREATE TABLE Configurations (
	Id serial primary key,
	Name varchar(255),
	Params json
);

INSERT INTO Configurations(name, params) 
VALUES ('redis',
		'{"monitoringScenario": "prepublic",
		  "endpoint": "localhost",
		  "hmap": "STATS_NUMBERS",
		  "labels": {"collectionType":"redis"},
		  "redisQueries": {
				"Results": "res",
			    "Projects": "proj",
			    "Publications": "pubs",
			    "Open Access Publications": "oapubs",
			    "Closed Access Publications": "noapubs",
			    "FP7 Publications": "fp7pubstotal",
			    "FP7 Open Access Publications": "fp7oapubs",
			    "FP7 Restricted Access Publications": "fp7respubs",
			    "FP7 Embargo Access Publications": "fp7embpubs",
			    "FP7 Projects with Publications": "fp7projpubs",
			    "FP7 Projects": "fp7projtotal",
			    "FP7 Projects with SC39": "sc39fp7projtotal",
			    "FP7 Projects with SC39 that have publications": "sc39fp7projpubs",
			    "OA publications in FP7 Projects with SC39": "sc39fp7oapubs",
			    "WT Projects": "wtprojtotal",
			    "WT Projects with Publications": "wtprojpubs",
			    "Publications in WT Projects": "wtpubs",
			    "Open Access Publications in WT Projects": "wtoapubs",
			    "Restricted Access Publications in WT Projects": "wtrespubs",
			    "Embargo Publications in WT Projects": "wtembpubs",
			    "Projects with ERC funding": "ercprojtotal",
			    "ERC Projects with Publications": "ercprojpubs",
			    "Open Access Publications in ERC Projects": "ercoapubs",
			    "Restricted Publications in ERC Projects": "ercrespubs",
			    "Embargo Publications in ERC Projects": "ercembpubs",
			    "Total Publications in ERC Projects": "ercpubs",
			    "Total Datasources": "datasrc",
			    "Valid Datasources": "dtsrcpubs",
			    "Datasources with Publications": "datasrc_withpubs",
			    "Journal Datasources": "datasrc_journals",
			    "Publication Repository Datasources": "datasrc_pubrepo",
			    "Data Repository Datasources": "datasrc_datarepo",
			    "Aggregator Datasources": "datasrc_aggr",
			    "Total number of datasets": "data_total",
			    "Funders": "funders",
			    "Organizations with Publications": "org_withpubs"}
		}'
);
		
INSERT INTO Configurations(name, params) 
VALUES ('solr',
		'{"monitoringScenario": "prepublic",
		  "endpoint": "beta.solr.openaire.eu:9983",
		  "collection": "DMF-index-openaire",
		  "labels": {"collectionType": "solr"},
		  "solrQueries": {
			    "Results": "oaftype:result AND deletedbyinference:false",
			    "Projects": "oaftype:project",
			    "Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication",
			    "Open Access Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND resultbestlicenseid exact \"OPEN\"",
			    "Closed Access Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND resultbestlicenseid exact \"CLOSED\"",
			    "FP7 Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"FP7\"",
			    "FP7 Closed Access Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"FP7\"AND resultbestlicenseid exact \"CLOSED\"",
			    "FP7 Open Access Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"FP7\"AND resultbestlicenseid exact \"OPEN\"",
			    "FP7 Restricted Access Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"FP7\"AND resultbestlicenseid exact \"RESTRICTED\"",
			    "FP7 Embargo Access Publications": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"FP7\"AND resultbestlicenseid exact \"EMBARGO\"",
			    "FP7 Projects": "oaftype:project AND fundinglevel0_id:\"corda_______::FP7\"",
			    "FP7 Projects with SC39": "oaftype:project AND fundinglevel0_id:\"corda_______::FP7\" AND projectecsc39:true",
			    "WT Projects": "oaftype:project AND fundinglevel0_id:\"wt::WT\"",
			    "Publications in WT Projects": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"WT\"",
			    "Open Access Publications in WT Projects": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"WT\"AND resultbestlicenseid exact \"OPEN\"",
			    "Restricted Access Publications in WT Projects": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"WT\"AND resultbestlicenseid exact \"RESTRICTED\"",
			    "Embargo Publications in WT Projects": "oaftype:result AND deletedbyinference:false AND resulttypeid:publication AND relfundinglevel0_id exact \"WT\"AND resultbestlicenseid exact \"EMBARGO\"",
			    "Projects with ERC funding": "oaftype:project AND fundinglevel2_name:ERC",
			    "Open Access Publications in ERC Projects": "resulttypeid:publication AND deletedbyinference:false AND conceptname:ERC AND resultbestlicenseid:OPEN",
			    "Restricted Publications in ERC Projects": "resulttypeid:publication AND deletedbyinference:false AND conceptname:ERC AND resultbestlicenseid:RESTRICTED",
			    "Embargo Publications in ERC Projects": "resulttypeid:publication AND deletedbyinference:false AND conceptname:ERC AND resultbestlicenseid:EMBARGO",
			    "Total Publications in ERC Projects": "resulttypeid:publication AND deletedbyinference:false AND conceptname:ERC",
			    "Total Datasources": "oaftype:datasource",
			    "Valid Datasources": "oaftype:datasource AND -datasourcecompatibilityid:UNKNOWN AND -datasourcecompatibilityid:notCompatible",
			    "Journal Datasources": "oaftype:datasource AND datasourcetypeid:\"pubsrepository::journal\"",
			    "Publication Repository Datasources": "oaftype:datasource AND datasourcetypeid:\"pubsrepository::unknown\"",
			    "Data Repository Datasources": "oaftype:datasource AND datasourcetypeid:\"datarepository::unknown\"",
			    "Aggregator Datasources": "oaftype:datasource AND datasourcetypeid:\"aggregator::pubsrepository::unknown\" OR datasourcetypeid:\"aggregator::pubsrepository::journals\" OR datasourcetypeid:\"aggregator::datarepository\"",
			    "Total number of datasets": "resulttypeid:dataset"}
		}'
);
