package eu.dnetlib.monitoring.server.dao.postgres.impl;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.util.PGobject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;

public class ConfigurationDAO implements GenericConfigurationDAO {

	private static final Log log = LogFactory.getLog(ControlDAO.class);

	private JdbcTemplate jdbcTemplate;
	private TransactionTemplate transactionTemplate;

	@Override
	public SensorConfiguration getConfiguration(final String configurationName) {
		log.info("Get conf " + configurationName);
		Map<String, Object> map = jdbcTemplate.queryForMap("SELECT params FROM configurations WHERE name = ?", configurationName);
		return new SensorConfiguration(PGJsonToMap(map.get("params")));
	}

	private Map<String, Object> PGJsonToMap(final Object obj) {
		Type listType = new TypeToken<Map<String, Object>>() {}.getType();
		if (obj != null) return new Gson().fromJson(((PGobject) obj).getValue(), listType);
		else return new HashMap<String, Object>();
	}

	@Override
	public List<String> listLabelNames(final String scenario, final String metric) {
		List<String> queryForList =
				jdbcTemplate.queryForList("SELECT DISTINCT json_object_keys(labels) AS l FROM logstash WHERE monitoringscenario=? AND metric=? ORDER BY l ASC",
						String.class, scenario, metric);
		return queryForList;
	}

	@Override
	public List<String> listLabelValues(final String scenario, final String metric, final String labenName) {
		List<String> queryForList =
				jdbcTemplate.queryForList(
						"SELECT DISTINCT labels->>? AS l FROM logstash WHERE monitoringscenario=? AND metric=? ORDER BY l ASC;",
						String.class, labenName, scenario, metric);
		return queryForList;
	}

	public JdbcTemplate getJdbcTemplate() {
		return jdbcTemplate;
	}

	public void setJdbcTemplate(final JdbcTemplate jdbcTemplate) {
		this.jdbcTemplate = jdbcTemplate;
	}

	public TransactionTemplate getTransactionTemplate() {
		return transactionTemplate;
	}

	public void setTransactionTemplate(final TransactionTemplate transactionTemplate) {
		this.transactionTemplate = transactionTemplate;
	}

}
