package eu.dnetlib.monitoring.configurations.rest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import eu.dnetlib.monitoring.model.SensorConfiguration;
import eu.dnetlib.monitoring.server.dao.GenericConfigurationDAO;

@Controller
@RequestMapping("/configurations")
public class ConfigurationController {

	@Autowired
	private GenericConfigurationDAO confDao;

	@RequestMapping(value = "/{name}", method = RequestMethod.GET)
	public @ResponseBody SensorConfiguration getConfigurationById(@PathVariable final String name) {
		SensorConfiguration configuration = confDao.getConfiguration(name);
		return configuration;
	}

}
