/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment.standalone;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.wildfly.plugin.common.DeploymentExecutionException;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.common.DeploymentInspector;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.MatchPatternStrategy;

public class StandaloneDeployment
implements Deployment {
    private final File content;
    private final ModelControllerClient client;
    private final String name;
    private final Deployment.Type type;
    private final String matchPattern;
    private final MatchPatternStrategy matchPatternStrategy;

    public StandaloneDeployment(ModelControllerClient client, File content, String name, Deployment.Type type, String matchPattern, MatchPatternStrategy matchPatternStrategy) {
        this.content = content;
        this.client = client;
        this.name = name == null ? content.getName() : name;
        this.type = type;
        this.matchPattern = matchPattern;
        this.matchPatternStrategy = matchPatternStrategy;
    }

    public static StandaloneDeployment create(ModelControllerClient client, File content, String name, Deployment.Type type, String matchPattern, MatchPatternStrategy matchPatternStrategy) {
        return new StandaloneDeployment(client, content, name, type, matchPattern, matchPatternStrategy);
    }

    private DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException, DeploymentFailureException {
        DeploymentPlanBuilder planBuilder = builder;
        List<String> existingDeployments = DeploymentInspector.getDeployments(this.client, this.name, this.matchPattern);
        switch (this.type) {
            case DEPLOY: {
                planBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case REDEPLOY: {
                planBuilder = builder.replace(this.name, this.content).redeploy(this.name);
                break;
            }
            case UNDEPLOY: {
                this.validateExistingDeployments(existingDeployments);
                planBuilder = this.undeployAndRemove(builder, existingDeployments);
                break;
            }
            case FORCE_DEPLOY: {
                if (existingDeployments.contains(this.name)) {
                    planBuilder = builder.replace(this.name, this.content).redeploy(this.name);
                    break;
                }
                planBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case UNDEPLOY_IGNORE_MISSING: {
                this.validateExistingDeployments(existingDeployments);
                if (!existingDeployments.isEmpty()) {
                    planBuilder = this.undeployAndRemove(builder, existingDeployments);
                    break;
                }
                return null;
            }
        }
        return planBuilder.build();
    }

    private DeploymentPlanBuilder undeployAndRemove(DeploymentPlanBuilder builder, List<String> deploymentNames) {
        DeploymentPlanBuilder planBuilder = builder;
        for (String deploymentName : deploymentNames) {
            planBuilder = planBuilder.undeploy(deploymentName).andRemoveUndeployed();
            if (this.matchPatternStrategy != MatchPatternStrategy.FIRST) continue;
            break;
        }
        return planBuilder;
    }

    private void validateExistingDeployments(List<String> existingDeployments) throws DeploymentFailureException {
        if (this.matchPattern == null) {
            return;
        }
        if (this.matchPatternStrategy == MatchPatternStrategy.FAIL && existingDeployments.size() > 1) {
            throw new DeploymentFailureException(String.format("Deployment failed, found %d deployed artifacts for pattern '%s' (%s)", existingDeployments.size(), this.matchPattern, existingDeployments));
        }
    }

    @Override
    public Deployment.Status execute() throws DeploymentExecutionException, DeploymentFailureException {
        Deployment.Status resultStatus = Deployment.Status.SUCCESS;
        try {
            ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client);
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan != null && plan.getDeploymentActions().size() > 0) {
                ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)manager.execute(plan).get();
                for (DeploymentAction action : plan.getDeploymentActions()) {
                    ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
                    ServerUpdateActionResult.Result result = actionResult.getResult();
                    switch (result) {
                        case FAILED: {
                            throw new DeploymentExecutionException("Deployment failed.", actionResult.getDeploymentException());
                        }
                        case NOT_EXECUTED: {
                            throw new DeploymentExecutionException("Deployment not executed.", actionResult.getDeploymentException());
                        }
                        case ROLLED_BACK: {
                            throw new DeploymentExecutionException("Deployment failed and was rolled back.", actionResult.getDeploymentException());
                        }
                        case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                            resultStatus = Deployment.Status.REQUIRES_RESTART;
                        }
                    }
                }
            }
        }
        catch (DeploymentExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentExecutionException(e, "Error executing %s", new Object[]{this.type});
        }
        return resultStatus;
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }
}

