/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.GenericParamAndConstraints;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.Type;
import java.util.LinkedList;
import java.util.List;

public abstract class MethodBase
extends MemberInfo {
    private List mVars = new LinkedList();
    private GenericParamAndConstraints[] sortedMVars = null;
    public final short Attributes;
    public final short CallingConvention;
    protected ParameterInfo[] params;
    protected short implAttributes;

    public void addMVar(GenericParamAndConstraints tvarAndConstraints) {
        this.sortedMVars = null;
        this.mVars.add(tvarAndConstraints);
    }

    public GenericParamAndConstraints[] getSortedMVars() {
        if (this.sortedMVars == null) {
            this.sortedMVars = new GenericParamAndConstraints[this.mVars.size()];
            for (int i = 0; i < this.sortedMVars.length; ++i) {
                for (GenericParamAndConstraints tvC : this.mVars) {
                    if (tvC.Number != i) continue;
                    this.sortedMVars[i] = tvC;
                }
            }
        }
        return this.sortedMVars;
    }

    public final boolean IsGeneric() {
        return this.mVars.size() > 0;
    }

    public abstract boolean IsConstructor();

    public final boolean IsAbstract() {
        return (this.Attributes & 0x400) != 0;
    }

    public final boolean IsFinal() {
        return (this.Attributes & 0x20) != 0;
    }

    public final boolean IsVirtual() {
        return (this.Attributes & 0x40) != 0;
    }

    public final boolean IsInstance() {
        return !this.IsStatic() && !this.IsVirtual();
    }

    public final boolean IsStatic() {
        return (this.Attributes & 0x10) != 0;
    }

    public final boolean IsHideBySig() {
        return (this.Attributes & 0x80) != 0;
    }

    public final boolean IsSpecialName() {
        return (this.Attributes & 0x800) != 0;
    }

    public final boolean IsPublic() {
        return (this.Attributes & 7) == 6;
    }

    public final boolean IsPrivate() {
        return (this.Attributes & 7) == 1;
    }

    public final boolean IsFamily() {
        return (this.Attributes & 7) == 4;
    }

    public final boolean IsAssembly() {
        return (this.Attributes & 7) == 3;
    }

    public final boolean IsFamilyOrAssembly() {
        return (this.Attributes & 7) == 5;
    }

    public final boolean IsFamilyAndAssembly() {
        return (this.Attributes & 7) == 2;
    }

    public boolean HasPtrParamOrRetType() {
        ParameterInfo[] ps = this.GetParameters();
        for (int i = 0; i < ps.length; ++i) {
            Type pT = ps[i].ParameterType;
            if (pT.IsPointer()) {
                return true;
            }
            if (!pT.IsByRef() || pT.GetElementType().CanBeTakenAddressOf()) continue;
            return true;
        }
        return false;
    }

    public ParameterInfo[] GetParameters() {
        return (ParameterInfo[])this.params.clone();
    }

    public int GetMethodImplementationFlags() {
        return this.implAttributes;
    }

    protected MethodBase(String name, Type declType, int attrs, Type[] paramTypes2) {
        this(name, declType, attrs);
        assert (paramTypes2 != null);
        this.params = new ParameterInfo[paramTypes2.length];
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = new ParameterInfo(null, paramTypes2[i], 0, i);
        }
    }

    protected MethodBase(String name, Type declType, int attrs, ParameterInfo[] params2) {
        this(name, declType, attrs);
        this.params = params2;
    }

    private MethodBase(String name, Type declType, int attrs) {
        super(name, declType);
        this.Attributes = (short)attrs;
        if (this.IsConstructor()) {
            attrs |= 0x800;
            attrs |= 0x1000;
        }
        this.CallingConvention = (short)(1 | (this.IsStatic() ? 0 : 32));
    }

    protected String params2String() {
        StringBuffer s = new StringBuffer("(");
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.params[i].ParameterType);
        }
        s.append(")");
        return s.toString();
    }
}

