/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.StoreNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreFactory {
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final WindowPoolFactory windowPoolFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final StringLogger stringLogger;
    private final RemoteTxHook txHook;
    public static final String LABELS_PART = ".labels";
    public static final String NAMES_PART = ".names";
    public static final String INDEX_PART = ".index";
    public static final String KEYS_PART = ".keys";
    public static final String ARRAYS_PART = ".arrays";
    public static final String STRINGS_PART = ".strings";
    public static final String NODE_STORE_NAME = ".nodestore.db";
    public static final String NODE_LABELS_STORE_NAME = ".nodestore.db.labels";
    public static final String PROPERTY_STORE_NAME = ".propertystore.db";
    public static final String PROPERTY_KEY_TOKEN_STORE_NAME = ".propertystore.db.index";
    public static final String PROPERTY_KEY_TOKEN_NAMES_STORE_NAME = ".propertystore.db.index.keys";
    public static final String PROPERTY_STRINGS_STORE_NAME = ".propertystore.db.strings";
    public static final String PROPERTY_ARRAYS_STORE_NAME = ".propertystore.db.arrays";
    public static final String RELATIONSHIP_STORE_NAME = ".relationshipstore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_STORE_NAME = ".relationshiptypestore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_NAMES_STORE_NAME = ".relationshiptypestore.db.names";
    public static final String LABEL_TOKEN_STORE_NAME = ".labeltokenstore.db";
    public static final String LABEL_TOKEN_NAMES_STORE_NAME = ".labeltokenstore.db.names";
    public static final String SCHEMA_STORE_NAME = ".schemastore.db";

    public StoreFactory(Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, RemoteTxHook txHook) {
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.windowPoolFactory = windowPoolFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.stringLogger = stringLogger;
        this.txHook = txHook;
    }

    public boolean ensureStoreExists() throws IOException {
        boolean readOnly = this.config.get(GraphDatabaseSettings.read_only);
        File store = this.config.get(GraphDatabaseSettings.neo_store);
        boolean created = false;
        if (!readOnly && !this.fileSystemAbstraction.fileExists(store)) {
            this.stringLogger.info("Creating new db @ " + store);
            this.fileSystemAbstraction.mkdirs(store.getParentFile());
            this.createNeoStore(store).close();
            created = true;
        }
        return created;
    }

    public NeoStore newNeoStore(File fileName) {
        try {
            return this.attemptNewNeoStore(fileName);
        }
        catch (NotCurrentStoreVersionException e) {
            this.tryToUpgradeStores(fileName);
            return this.attemptNewNeoStore(fileName);
        }
        catch (StoreNotFoundException e) {
            this.tryToUpgradeStores(fileName);
            return this.attemptNewNeoStore(fileName);
        }
    }

    NeoStore attemptNewNeoStore(File fileName) {
        return new NeoStore(fileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, this.txHook, this.newRelationshipTypeTokenStore(new File(fileName.getPath() + RELATIONSHIP_TYPE_TOKEN_STORE_NAME)), this.newLabelTokenStore(new File(fileName.getPath() + LABEL_TOKEN_STORE_NAME)), this.newPropertyStore(new File(fileName.getPath() + PROPERTY_STORE_NAME)), this.newRelationshipStore(new File(fileName.getPath() + RELATIONSHIP_STORE_NAME)), this.newNodeStore(new File(fileName.getPath() + NODE_STORE_NAME)), this.newSchemaStore(new File(fileName.getPath() + SCHEMA_STORE_NAME)));
    }

    private void tryToUpgradeStores(File fileName) {
        new StoreUpgrader(this.config, new ConfigMapUpgradeConfiguration(this.config), new UpgradableDatabase(new StoreVersionCheck(this.fileSystemAbstraction)), new StoreMigrator(new VisibleMigrationProgressMonitor(this.stringLogger, System.out)), new DatabaseFiles(this.fileSystemAbstraction), this.idGeneratorFactory, this.fileSystemAbstraction).attemptUpgrade(fileName);
    }

    public SchemaStore newSchemaStore(File file) {
        return new SchemaStore(file, this.config, IdType.SCHEMA, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    private DynamicStringStore newDynamicStringStore(File fileName, IdType nameIdType) {
        return new DynamicStringStore(fileName, this.config, nameIdType, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    private RelationshipTypeTokenStore newRelationshipTypeTokenStore(File baseFileName) {
        DynamicStringStore nameStore = this.newDynamicStringStore(new File(baseFileName.getPath() + NAMES_PART), IdType.RELATIONSHIP_TYPE_TOKEN_NAME);
        return new RelationshipTypeTokenStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    public PropertyStore newPropertyStore(File baseFileName) {
        DynamicStringStore stringPropertyStore = this.newDynamicStringStore(new File(baseFileName.getPath() + STRINGS_PART), IdType.STRING_BLOCK);
        PropertyKeyTokenStore propertyKeyTokenStore = this.newPropertyKeyTokenStore(new File(baseFileName.getPath() + INDEX_PART));
        DynamicArrayStore arrayPropertyStore = this.newDynamicArrayStore(new File(baseFileName.getPath() + ARRAYS_PART));
        return new PropertyStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, stringPropertyStore, propertyKeyTokenStore, arrayPropertyStore);
    }

    public PropertyKeyTokenStore newPropertyKeyTokenStore(File baseFileName) {
        DynamicStringStore nameStore = this.newDynamicStringStore(new File(baseFileName.getPath() + KEYS_PART), IdType.PROPERTY_KEY_TOKEN_NAME);
        return new PropertyKeyTokenStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    private LabelTokenStore newLabelTokenStore(File baseFileName) {
        DynamicStringStore nameStore = this.newDynamicStringStore(new File(baseFileName.getPath() + NAMES_PART), IdType.LABEL_TOKEN_NAME);
        return new LabelTokenStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    private RelationshipStore newRelationshipStore(File baseFileName) {
        return new RelationshipStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    public DynamicArrayStore newDynamicArrayStore(File baseFileName) {
        return new DynamicArrayStore(baseFileName, this.config, IdType.ARRAY_BLOCK, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    public NodeStore newNodeStore(File baseFileName) {
        File labelsFileName = new File(baseFileName.getPath() + LABELS_PART);
        DynamicArrayStore dynamicLabelStore = new DynamicArrayStore(labelsFileName, this.config, IdType.NODE_LABELS, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
        return new NodeStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, dynamicLabelStore);
    }

    public NeoStore createNeoStore(File fileName) {
        return this.createNeoStore(fileName, new StoreId());
    }

    public NeoStore createNeoStore(File fileName, StoreId storeId) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("NeoStore"));
        this.createNodeStore(new File(fileName.getPath() + NODE_STORE_NAME));
        this.createRelationshipStore(new File(fileName.getPath() + RELATIONSHIP_STORE_NAME));
        this.createPropertyStore(new File(fileName.getPath() + PROPERTY_STORE_NAME));
        this.createRelationshipTypeStore(new File(fileName.getPath() + RELATIONSHIP_TYPE_TOKEN_STORE_NAME));
        this.createLabelTokenStore(new File(fileName.getPath() + LABEL_TOKEN_STORE_NAME));
        this.createSchemaStore(new File(fileName.getPath() + SCHEMA_STORE_NAME));
        NeoStore neoStore = this.newNeoStore(fileName);
        for (int i = 0; i < 6; ++i) {
            neoStore.nextId();
        }
        neoStore.setCreationTime(storeId.getCreationTime());
        neoStore.setRandomNumber(storeId.getRandomId());
        neoStore.setVersion(0L);
        neoStore.setLastCommittedTx(1L);
        neoStore.setStoreVersion(storeId.getStoreVersion());
        neoStore.setGraphNextProp(-1L);
        return neoStore;
    }

    public void createNodeStore(File fileName) {
        this.createNodeLabelsStore(new File(fileName.getPath() + LABELS_PART));
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("NodeStore"));
    }

    private void createNodeLabelsStore(File fileName) {
        int labelStoreBlockSize = this.config.get(Configuration.label_block_size);
        this.createEmptyDynamicStore(fileName, labelStoreBlockSize, DynamicArrayStore.VERSION, IdType.NODE_LABELS);
    }

    private void createRelationshipStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    public void createPropertyStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("PropertyStore"));
        int stringStoreBlockSize = this.config.get(Configuration.string_block_size);
        int arrayStoreBlockSize = this.config.get(Configuration.array_block_size);
        this.createDynamicStringStore(new File(fileName.getPath() + STRINGS_PART), stringStoreBlockSize, IdType.STRING_BLOCK);
        this.createPropertyKeyTokenStore(new File(fileName.getPath() + INDEX_PART));
        this.createDynamicArrayStore(new File(fileName.getPath() + ARRAYS_PART), arrayStoreBlockSize);
    }

    private void createRelationshipTypeStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
        this.createDynamicStringStore(new File(fileName.getPath() + NAMES_PART), 30, IdType.RELATIONSHIP_TYPE_TOKEN_NAME);
        RelationshipTypeTokenStore store = this.newRelationshipTypeTokenStore(fileName);
        store.close();
    }

    private void createLabelTokenStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("LabelTokenStore"));
        this.createDynamicStringStore(new File(fileName.getPath() + NAMES_PART), 30, IdType.LABEL_TOKEN_NAME);
        LabelTokenStore store = this.newLabelTokenStore(fileName);
        store.close();
    }

    private void createDynamicStringStore(File fileName, int blockSize, IdType idType) {
        this.createEmptyDynamicStore(fileName, blockSize, DynamicStringStore.VERSION, idType);
    }

    private void createPropertyKeyTokenStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("PropertyIndexStore"));
        this.createDynamicStringStore(new File(fileName.getPath() + KEYS_PART), 30, IdType.PROPERTY_KEY_TOKEN_NAME);
    }

    public void createDynamicArrayStore(File fileName, int blockSize) {
        this.createEmptyDynamicStore(fileName, blockSize, DynamicArrayStore.VERSION, IdType.ARRAY_BLOCK);
    }

    public void createSchemaStore(File fileName) {
        this.createEmptyDynamicStore(fileName, 56, SchemaStore.VERSION, IdType.SCHEMA);
    }

    public void createEmptyDynamicStore(File fileName, int baseBlockSize, String typeAndVersionDescriptor, IdType idType) {
        int blockSize = baseBlockSize;
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "]");
        }
        if (blockSize > 65535) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "], limit is 65535");
        }
        blockSize += 8;
        try {
            StoreChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = blockSize + UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.putInt(blockSize);
            buffer.position(endHeaderSize - typeAndVersionDescriptor.length());
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 0L);
        IdGenerator idGenerator = this.idGeneratorFactory.open(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), idType.getGrabSize(), idType, 0L);
        idGenerator.nextId();
        idGenerator.close();
    }

    public void createEmptyStore(File fileName, String typeAndVersionDescriptor) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            StoreChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 0L);
    }

    public String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return typeDescriptor + " " + "v0.A.1";
    }

    public static abstract class Configuration {
        public static final Setting<Integer> string_block_size = GraphDatabaseSettings.string_block_size;
        public static final Setting<Integer> array_block_size = GraphDatabaseSettings.array_block_size;
        public static final Setting<Integer> label_block_size = GraphDatabaseSettings.label_block_size;
    }
}

